/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import javax.inject.Inject;
import net.neoforged.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.runtime.naming.NamingChannelProvider;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.InterfaceInjections;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

public abstract class MinecraftExtension
implements ConfigurableDSLElement<Minecraft>,
Minecraft {
    private final Project project;
    private final AccessTransformers accessTransformers;
    private final InterfaceInjections interfaceInjections;
    private final NamedDomainObjectContainer<NamingChannel> namingChannelProviders;

    @Inject
    public MinecraftExtension(Project project) {
        this.project = project;
        this.accessTransformers = (AccessTransformers)project.getExtensions().getByType(AccessTransformers.class);
        this.interfaceInjections = (InterfaceInjections)project.getExtensions().getByType(InterfaceInjections.class);
        this.namingChannelProviders = project.getObjects().domainObjectContainer(NamingChannel.class, name -> (NamingChannel)project.getObjects().newInstance(NamingChannelProvider.class, new Object[]{project, name}));
        String baseName = project.getName().replace(":", "_");
        this.getModIdentifier().convention(project.provider(() -> {
            if (baseName.startsWith("_")) {
                return baseName.substring(1);
            }
            return baseName;
        }));
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public NamedDomainObjectContainer<NamingChannel> getNamingChannels() {
        return this.namingChannelProviders;
    }

    @NotNull
    public Mappings getMappings() {
        return (Mappings)this.project.getExtensions().getByType(Mappings.class);
    }

    @NotNull
    public AccessTransformers getAccessTransformers() {
        return this.accessTransformers;
    }

    @NotNull
    public InterfaceInjections getInterfaceInjections() {
        return this.interfaceInjections;
    }
}

