/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.reflect.Instantiator;

public class ReflectiveFallbackInstantiator
implements Instantiator {
    private final Instantiator primary;

    public static Instantiator create(Project project) {
        return ReflectiveFallbackInstantiator.create((arg_0, arg_1) -> ((ObjectFactory)project.getObjects()).newInstance(arg_0, arg_1));
    }

    public static Instantiator create(Instantiator primary) {
        return new ReflectiveFallbackInstantiator(primary);
    }

    private ReflectiveFallbackInstantiator(Instantiator primary) {
        this.primary = primary;
    }

    public <T> T newInstance(Class<? extends T> aClass, Object ... objects) throws ObjectInstantiationException {
        try {
            return this.newInstanceFromPrimary(aClass, objects);
        }
        catch (Throwable throwable) {
            try {
                return this.newInstanceFromReflection(aClass, objects);
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                throw new ObjectInstantiationException(aClass, throwable);
            }
        }
    }

    private <T> T newInstanceFromPrimary(Class<? extends T> aClass, Object ... objects) throws Throwable {
        return (T)this.primary.newInstance(aClass, objects);
    }

    private <T> T newInstanceFromReflection(Class<? extends T> aClass, Object ... objects) throws Throwable {
        Class[] classesOfObjects = (Class[])Arrays.stream(objects).map(Object::getClass).toArray(Class[]::new);
        Constructor<T> constructor = aClass.getConstructor(classesOfObjects);
        return constructor.newInstance(objects);
    }
}

