/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.neoforged.gradle.common.tasks.MinecraftArtifactFileCacheProvider;
import net.neoforged.gradle.common.tasks.MinecraftLauncherFileCacheProvider;
import net.neoforged.gradle.common.tasks.MinecraftVersionManifestFileCacheProvider;
import net.neoforged.gradle.common.util.MinecraftArtifactType;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class FileCacheUtils {
    private FileCacheUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: FileCacheUtils. This is a utility class");
    }

    @NotNull
    public static TaskProvider<MinecraftLauncherFileCacheProvider> createLauncherMetadataFileCacheProvidingTask(Project project) {
        if (project.getTasks().getNames().contains("cacheLauncherMetadata")) {
            return project.getTasks().named("cacheLauncherMetadata", MinecraftLauncherFileCacheProvider.class);
        }
        return project.getTasks().register("cacheLauncherMetadata", MinecraftLauncherFileCacheProvider.class, task -> {});
    }

    @NotNull
    public static TaskProvider<MinecraftVersionManifestFileCacheProvider> createVersionManifestFileCacheProvidingTask(Project project, String minecraftVersion, TaskProvider<MinecraftLauncherFileCacheProvider> launcherProvider) {
        if (project.getTasks().getNames().contains("cacheVersionManifest" + minecraftVersion)) {
            return project.getTasks().named("cacheVersionManifest" + minecraftVersion, MinecraftVersionManifestFileCacheProvider.class);
        }
        return project.getTasks().register("cacheVersionManifest" + minecraftVersion, MinecraftVersionManifestFileCacheProvider.class, task -> {
            task.getMinecraftVersion().set((Object)minecraftVersion);
            task.getLauncherManifest().set(launcherProvider.flatMap(OutputSpecification::getOutput));
        });
    }

    @NotNull
    public static TaskProvider<MinecraftArtifactFileCacheProvider> createArtifactFileCacheProvidingTask(Project project, String minecraftVersion, DistributionType distributionType, MinecraftArtifactType type, TaskProvider<MinecraftVersionManifestFileCacheProvider> versionManifestProvider, Collection<TaskProvider<? extends WithOutput>> otherProviders) {
        String taskName = "cacheVersion" + StringUtils.capitalize((String)type.name().toLowerCase()) + StringUtils.capitalize((String)distributionType.getName().toLowerCase()) + minecraftVersion;
        if (project.getTasks().getNames().contains(taskName)) {
            return project.getTasks().named(taskName, MinecraftArtifactFileCacheProvider.class);
        }
        CacheFileSelector selector = type == MinecraftArtifactType.MAPPINGS ? CacheFileSelector.forVersionMappings((String)minecraftVersion, (String)distributionType.getName()) : CacheFileSelector.forVersionJar((String)minecraftVersion, (String)distributionType.getName());
        ArrayList<TaskProvider<? extends WithOutput>> taskOrdering = new ArrayList<TaskProvider<? extends WithOutput>>(otherProviders);
        return project.getTasks().register(taskName, MinecraftArtifactFileCacheProvider.class, task -> {
            task.getDistributionType().set((Object)distributionType);
            task.getManifest().set(versionManifestProvider.flatMap(OutputSpecification::getOutput));
            task.getArtifactType().set((Object)type);
            task.getDistributionType().set((Object)distributionType);
            task.getSelector().set((Object)selector);
            taskOrdering.forEach(xva$0 -> task.mustRunAfter(new Object[]{xva$0}));
        });
    }

    @NotNull
    public static DirectoryProperty getAssetsCacheDirectory(Project project) {
        return project.getObjects().directoryProperty().fileValue(new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraft/assets"));
    }

    @NotNull
    public static DirectoryProperty getLibrariesCacheDirectory(Project project) {
        return project.getObjects().directoryProperty().fileValue(new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraft/libraries"));
    }
}

