/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class RawAndSourceCombiner
extends NeoGradleBase
implements WithOutput {
    @TaskAction
    public void doCombine() {
        File rawJarOutput = this.ensureFileWorkspaceReady(this.getOutput());
        File sourceJarOutput = this.ensureFileWorkspaceReady(this.getSourceJarOutput());
        File rawJarInput = (File)this.getInput().getAsFile().get();
        File sourceJarInput = (File)this.getSourceJarInput().getAsFile().get();
        RawAndSourceCombiner.copy(rawJarInput, rawJarOutput);
        RawAndSourceCombiner.copy(sourceJarInput, sourceJarOutput);
    }

    private static void copy(File input, File output) {
        try {
            Files.copy((File)input, (File)output);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to copy: %s to output: %s", input.getAbsolutePath(), output.getAbsolutePath()), e);
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getSourceJarInput();

    @OutputFile
    public abstract RegularFileProperty getSourceJarOutput();
}

