/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming.renamer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.neoforged.gradle.common.runtime.naming.renamer.ISourceRenamer;
import net.neoforged.gradle.util.JavadocAdder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.tasks.Nested;

public abstract class RegexBasedSourceRenamer
implements ISourceRenamer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Pattern SRG_FINDER = Pattern.compile("[fF]unc_\\d+_[a-zA-Z_]+|m_\\d+_|[fF]ield_\\d+_[a-zA-Z_]+|f_\\d+_|p_\\w+_\\d+_|p_\\d+_");
    private static final Pattern CONSTRUCTOR_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(public |private|protected |)(?<generic><[\\w\\W]*>\\s+)?(?<name>[\\w.]+)\\((?<parameters>.*)\\)\\s+(?:throws[\\w.,\\s]+)?\\{");
    private static final Pattern METHOD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?<generic><[\\w\\W]*>\\s+)?(?<return>\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>(?:func_|m_)[0-9]+_[a-zA-Z_]*)\\(");
    private static final Pattern FIELD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*\\s+(?<name>(?:field_|f_)[0-9]+_[a-zA-Z_]*) *[=;]");
    private static final Pattern CLASS_JAVADOC_PATTERN = Pattern.compile("^(?<indent> *|\\t*)([\\w|@]*\\s)*(class|interface|@interface|enum) (?<name>[\\w]+)");
    private static final Pattern CLOSING_CURLY_BRACE = Pattern.compile("^(?<indent> *|\\t*)}");
    private static final Pattern PACKAGE_DECL = Pattern.compile("^[\\s]*package(\\s)*(?<name>[\\w|.]+);$");
    private static final Pattern LAMBDA_DECL = Pattern.compile("\\((?<args>(?:(?:, ){0,1}p_[\\w]+_\\d+_\\b)+)\\) ->");

    private static void insertAboveAnnotations(List<String> list, String line) {
        int back = 0;
        while (list.get(list.size() - 1 - back).trim().startsWith("@")) {
            ++back;
        }
        list.add(list.size() - back, line);
    }

    public byte[] rename(byte[] classFile, boolean javadocs) throws IOException {
        return this.rename(classFile, javadocs, true, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] rename(byte[] classFile, boolean javadocs, boolean lambdas) throws IOException {
        return this.rename(classFile, javadocs, lambdas, StandardCharsets.UTF_8);
    }

    public byte[] rename(byte[] classFile, boolean javadocs, boolean lambdas, Charset sourceFileCharset) throws IOException {
        Matcher m;
        String data = new String(classFile, sourceFileCharset);
        List input = IOUtils.readLines((Reader)new StringReader(data));
        if (data.isEmpty()) {
            return "".getBytes(sourceFileCharset);
        }
        if (data.charAt(data.length() - 1) == '\r' || data.charAt(data.length() - 1) == '\n') {
            input.add("");
        }
        ArrayList<String> lines = new ArrayList<String>();
        LinkedList<Pair<String, Integer>> innerClasses = new LinkedList<Pair<String, Integer>>();
        String _package = "";
        HashSet<String> blacklist = null;
        if (!lambdas) {
            blacklist = new HashSet<String>();
            for (String line : input) {
                m = LAMBDA_DECL.matcher(line);
                if (!m.find()) continue;
                blacklist.addAll(Arrays.asList(m.group("args").split(", ")));
            }
        }
        for (String line : input) {
            m = PACKAGE_DECL.matcher(line);
            if (m.find()) {
                _package = m.group("name") + ".";
            }
            if (javadocs && !this.injectJavadoc(lines, line, _package, innerClasses)) {
                javadocs = false;
            }
            lines.add(this.rename(line, blacklist));
        }
        return String.join((CharSequence)NEWLINE, lines).getBytes(sourceFileCharset);
    }

    private boolean injectJavadoc(List<String> lines, String line, String _package, Deque<Pair<String, Integer>> innerClasses) {
        boolean isConstructor;
        Matcher matcher = CONSTRUCTOR_JAVADOC_PATTERN.matcher(line);
        boolean bl = isConstructor = matcher.find() && !innerClasses.isEmpty() && ((String)innerClasses.peek().getLeft()).contains(matcher.group("name"));
        if (!isConstructor) {
            matcher = METHOD_JAVADOC_PATTERN.matcher(line);
        }
        if (isConstructor || matcher.find()) {
            String name = isConstructor ? "<init>" : matcher.group("name");
            String javadoc = this.getDocs().get(name);
            if (!(javadoc != null || innerClasses.isEmpty() || name.startsWith("func_") || name.startsWith("m_"))) {
                String currentClass = (String)innerClasses.peek().getLeft();
                javadoc = this.getDocs().get(currentClass + '#' + name);
            }
            if (javadoc != null) {
                RegexBasedSourceRenamer.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc((String)matcher.group("indent"), (String)javadoc, (boolean)true));
            }
            return true;
        }
        matcher = FIELD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String name = matcher.group("name");
            String javadoc = this.getDocs().get(name);
            if (!(javadoc != null || innerClasses.isEmpty() || name.startsWith("field_") || name.startsWith("f_"))) {
                String currentClass = (String)innerClasses.peek().getLeft();
                javadoc = this.getDocs().get(currentClass + '#' + name);
            }
            if (javadoc != null) {
                RegexBasedSourceRenamer.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc((String)matcher.group("indent"), (String)javadoc, (boolean)false));
            }
            return true;
        }
        matcher = CLASS_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String currentClass = (innerClasses.isEmpty() ? _package : (String)innerClasses.peek().getLeft() + "$") + matcher.group("name");
            innerClasses.push((Pair<String, Integer>)Pair.of((Object)currentClass, (Object)matcher.group("indent").length()));
            String javadoc = this.getDocs().get(currentClass);
            if (javadoc != null) {
                RegexBasedSourceRenamer.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc((String)matcher.group("indent"), (String)javadoc, (boolean)true));
            }
            return true;
        }
        matcher = CLOSING_CURLY_BRACE.matcher(line);
        if (matcher.find() && !innerClasses.isEmpty()) {
            int len = matcher.group("indent").length();
            if (len == (Integer)innerClasses.peek().getRight()) {
                innerClasses.pop();
            } else if (len < (Integer)innerClasses.peek().getRight()) {
                System.err.println("Failed to properly track class blocks around class " + (String)innerClasses.peek().getLeft() + ":" + (lines.size() + 1));
                return false;
            }
        }
        return true;
    }

    private String getMapped(String srg, @Nullable Set<String> blacklist) {
        boolean cap;
        if (blacklist != null && blacklist.contains(srg)) {
            return srg;
        }
        boolean bl = cap = srg.charAt(0) == 'F';
        if (cap) {
            srg = 'f' + srg.substring(1);
        }
        String ret = this.getNames().getOrDefault(srg, srg);
        if (cap) {
            ret = ret.substring(0, 1).toUpperCase(Locale.ENGLISH) + ret.substring(1);
        }
        return ret;
    }

    private String rename(String line) {
        return this.rename(line, null);
    }

    private String rename(String line, @Nullable Set<String> blacklist) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = SRG_FINDER.matcher(line);
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement(this.getMapped(matcher.group(), blacklist)));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Nested
    public abstract Map<String, String> getNames();

    @Nested
    public abstract Map<String, String> getDocs();
}

