/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.minecraftforge.gdi.ProjectAssociatedDSLElement;
import net.neoforged.gradle.common.extensions.repository.IvyDummyRepositoryReference;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryEntry;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryReference;
import net.neoforged.gradle.dsl.common.util.ModuleReference;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import net.neoforged.gradle.util.ResolvedDependencyUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.jetbrains.annotations.NotNull;

public abstract class IvyDummyRepositoryEntry
implements ConfigurableDSLElement<IvyDummyRepositoryEntry>,
RepositoryEntry<IvyDummyRepositoryEntry, IvyDummyRepositoryReference>,
Serializable,
ProjectAssociatedDSLElement {
    public static final String NG_DUMMY_NG_MARKER = "ng_dummy_ng";
    private static final long serialVersionUID = 4025734172533096653L;
    private final transient Project project;
    private final String group;
    private final String name;
    private final String version;
    private final String classifier;
    private final String extension;
    private final Collection<RepositoryReference> dependencies;

    @Inject
    public IvyDummyRepositoryEntry(Project project, String group, String name, String version, String classifier, String extension, Collection<RepositoryReference> dependencies) {
        this.project = project;
        this.group = group;
        this.name = name;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
        this.dependencies = dependencies;
    }

    public Project getProject() {
        return this.project;
    }

    public String getFullGroup() {
        if (this.getGroup() == null) {
            return NG_DUMMY_NG_MARKER;
        }
        return String.format("%s.%s", NG_DUMMY_NG_MARKER, this.getGroup());
    }

    public boolean matches(ModuleComponentIdentifier id) {
        return this.getFullGroup().equals(id.getGroup()) && this.getName().equals(id.getModule()) && this.getVersion().equals(id.getVersion());
    }

    public IvyDummyRepositoryEntry asSources() {
        return Builder.create(this.project, this).setClassifier("sources").build();
    }

    public Path buildArtifactPath(Path baseDir) throws IOException {
        Path artifactPath = baseDir.resolve(this.buildArtifactPath());
        Files.createDirectories(artifactPath.getParent(), new FileAttribute[0]);
        return artifactPath;
    }

    public String buildArtifactPath() {
        String fileName = this.getClassifier() == null || this.getClassifier().equals("") ? String.format("%s-%s.%s", this.getName(), this.getVersion(), this.getExtension()) : String.format("%s-%s-%s.%s", this.getName(), this.getVersion(), this.getClassifier(), this.getExtension());
        String groupPath = this.getFullGroup().replace('.', '/') + '/';
        return String.format("%s%s/%s/%s", groupPath, this.getName(), this.getVersion(), fileName);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public Collection<? extends RepositoryReference> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IvyDummyRepositoryEntry that = (IvyDummyRepositoryEntry)obj;
        return Objects.equals(this.group, that.group) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.extension, that.extension) && Objects.equals(this.dependencies, that.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name, this.version, this.classifier, this.extension, this.dependencies);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String group = this.getFullGroup();
        String artifactName = this.getName();
        String version = this.getVersion();
        String extension = this.getExtension();
        String classifier = this.getClassifier();
        if (!group.trim().isEmpty()) {
            builder.append(group);
        }
        builder.append(":");
        builder.append(artifactName);
        builder.append(":");
        builder.append(version);
        if (classifier != null && !classifier.trim().isEmpty()) {
            builder.append(":");
            builder.append(classifier);
        }
        if (extension != null && !extension.trim().isEmpty() && !extension.trim().toLowerCase(Locale.ROOT).equals("jar")) {
            builder.append("@").append(extension);
        }
        return builder.toString();
    }

    public ModuleReference toModuleReference() {
        return new ModuleReference(this.getGroup(), this.getName(), this.getVersion(), this.getExtension(), this.getClassifier());
    }

    public Dependency toGradle(Project project) {
        return project.getDependencies().create((Object)this.toString());
    }

    public static abstract class Builder
    implements ConfigurableDSLElement<Builder>,
    RepositoryEntry.Builder<Builder, IvyDummyRepositoryReference, IvyDummyRepositoryReference.Builder> {
        private final Project project;
        private String group;
        private String name;
        private String version;
        private String classifier = "";
        private String extension = "jar";
        private final Set<RepositoryReference> dependencies = Sets.newHashSet();

        @Inject
        public Builder(Project project) {
            this.project = project;
        }

        public static Builder create(Project project) {
            return (Builder)project.getObjects().newInstance(Builder.class, new Object[]{project});
        }

        public static Builder create(Project project, IvyDummyRepositoryEntry entry) {
            return Builder.create(project).setGroup(entry.getGroup()).setName(entry.getName()).setVersion(entry.getVersion()).setClassifier(entry.getClassifier()).setExtension(entry.getExtension()).setDependencies((Collection)entry.getDependencies());
        }

        public Project getProject() {
            return this.project;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public ImmutableSet<? extends RepositoryReference> getDependencies() {
            return ImmutableSet.copyOf(this.dependencies);
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder setExtension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder from(ModuleDependency dependency) {
            this.setGroup(dependency.getGroup());
            this.setName(dependency.getName());
            this.setVersion(dependency.getVersion());
            this.setClassifier(ModuleDependencyUtils.getClassifierOrEmpty((ModuleDependency)dependency));
            this.setExtension(ModuleDependencyUtils.getExtensionOrJar((ModuleDependency)dependency));
            return this;
        }

        public Builder from(ResolvedDependency resolvedDependency) {
            this.setGroup(resolvedDependency.getModuleGroup());
            this.setName(resolvedDependency.getModuleName());
            this.setVersion(resolvedDependency.getModuleVersion());
            this.setClassifier(ResolvedDependencyUtils.getClassifierOrEmpty((ResolvedDependency)resolvedDependency));
            this.setExtension(ResolvedDependencyUtils.getExtensionOrJar((ResolvedDependency)resolvedDependency));
            return this;
        }

        public Builder setDependencies(Collection<? extends RepositoryReference> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder setDependencies(RepositoryReference ... dependencies) {
            this.dependencies.addAll(Arrays.asList(dependencies));
            return this;
        }

        public Builder withDependency(Consumer<IvyDummyRepositoryReference.Builder> consumer) {
            IvyDummyRepositoryReference.Builder builder = IvyDummyRepositoryReference.Builder.create(this.project);
            consumer.accept(builder);
            this.dependencies.add(builder.build());
            return this;
        }

        @NotNull
        public Builder withProcessedDependency(@NotNull Consumer<Builder> consumer) {
            Builder builder = Builder.create(this.project);
            consumer.accept(builder);
            this.dependencies.add((RepositoryReference)builder.build());
            return this;
        }

        public Builder but() {
            return Builder.create(this.project).setGroup(this.group).setName(this.name).setVersion(this.version).setClassifier(this.classifier).setExtension(this.extension).setDependencies(this.dependencies);
        }

        public IvyDummyRepositoryEntry build() {
            return (IvyDummyRepositoryEntry)this.project.getObjects().newInstance(IvyDummyRepositoryEntry.class, new Object[]{this.project, this.group, this.name, this.version != null ? this.version : "", this.classifier, this.extension, this.dependencies});
        }
    }
}

