/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util.run;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runs.tasks.RunExec;
import net.neoforged.gradle.dsl.common.extensions.ProjectHolder;
import net.neoforged.gradle.dsl.common.extensions.RunnableSourceSet;
import net.neoforged.gradle.dsl.common.runs.idea.extensions.IdeaRunsExtension;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public class RunsUtil {
    private RunsUtil() {
        throw new IllegalStateException("Tried to create utility class!");
    }

    public static Run create(Project project, String name) {
        RunImpl run = (RunImpl)project.getObjects().newInstance(RunImpl.class, new Object[]{project, name});
        TaskProvider runTask = project.getTasks().register(RunsUtil.createTaskName(name), RunExec.class, runExec -> runExec.getRun().set((Object)run));
        project.afterEvaluate(evaluatedProject -> runTask.configure(task -> {
            ((List)((Run)task.getRun().get()).getModSources().get()).stream().map(SourceSet::getClassesTaskName).map(classTaskName -> evaluatedProject.getTasks().named(classTaskName)).forEach(xva$0 -> task.dependsOn(new Object[]{xva$0}));
            run.getTaskDependencies().forEach(xva$0 -> task.dependsOn(new Object[]{xva$0}));
        }));
        run.getEnvironmentVariables().put((Object)"MOD_CLASSES", RunsUtil.buildGradleModClasses((ListProperty<SourceSet>)run.getModSources()));
        return run;
    }

    public static Provider<String> buildGradleModClasses(ListProperty<SourceSet> sourceSetsProperty) {
        return RunsUtil.buildGradleModClasses(sourceSetsProperty, sourceSet -> Stream.concat(Stream.of(sourceSet.getOutput().getResourcesDir()), sourceSet.getOutput().getClassesDirs().getFiles().stream()));
    }

    public static Provider<String> buildRunWithIdeaModClasses(ListProperty<SourceSet> sourceSetsProperty) {
        return RunsUtil.buildGradleModClasses(sourceSetsProperty, sourceSet -> {
            Project project = ((ProjectHolder)sourceSet.getExtensions().getByType(ProjectHolder.class)).getProject();
            IdeaModel rootIdeaModel = (IdeaModel)project.getRootProject().getExtensions().getByType(IdeaModel.class);
            IdeaRunsExtension ideaRunsExtension = (IdeaRunsExtension)((ExtensionAware)rootIdeaModel.getProject()).getExtensions().getByType(IdeaRunsExtension.class);
            if (((Boolean)ideaRunsExtension.getRunWithIdea().get()).booleanValue()) {
                File parentDir = ((Directory)ideaRunsExtension.getOutDirectory().get()).getAsFile();
                File sourceSetDir = new File(parentDir, RunsUtil.getIntellijOutName(sourceSet));
                return Stream.of(new File(sourceSetDir, "resources"), new File(sourceSetDir, "classes"));
            }
            return Stream.concat(Stream.of(sourceSet.getOutput().getResourcesDir()), sourceSet.getOutput().getClassesDirs().getFiles().stream());
        });
    }

    public static Provider<String> buildRunWithEclipseModClasses(ListProperty<SourceSet> sourceSetsProperty) {
        return RunsUtil.buildGradleModClasses(sourceSetsProperty, sourceSet -> {
            Project project = ((ProjectHolder)sourceSet.getExtensions().getByType(ProjectHolder.class)).getProject();
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            File conventionsDir = new File(project.getProjectDir(), "bin");
            eclipseModel.getClasspath().getBaseSourceOutputDir().convention(project.provider(() -> conventionsDir));
            File parentDir = (File)eclipseModel.getClasspath().getBaseSourceOutputDir().get();
            File sourceSetDir = new File(parentDir, sourceSet.getName());
            return Stream.of(sourceSetDir);
        });
    }

    public static String getIntellijOutName(@Nonnull SourceSet sourceSet) {
        return sourceSet.getName().equals("main") ? "production" : sourceSet.getName();
    }

    public static Provider<String> buildGradleModClasses(ListProperty<SourceSet> sourceSetsProperty, Function<SourceSet, Stream<File>> directoryBuilder) {
        return sourceSetsProperty.map(sourceSets -> {
            HashMultimap sourceSetsByRunId = HashMultimap.create();
            sourceSets.forEach(arg_0 -> RunsUtil.lambda$null$10((Multimap)sourceSetsByRunId, arg_0));
            return sourceSetsByRunId.entries().stream().flatMap(entry -> ((Stream)directoryBuilder.apply((SourceSet)entry.getValue())).map(directory -> String.format("%s%%%%%s", entry.getKey(), directory.getAbsolutePath()))).collect(Collectors.joining(File.pathSeparator));
        });
    }

    private static String createTaskName(String runName) {
        String conventionTaskName = runName.replaceAll("[^a-zA-Z0-9\\-_]", "");
        if (conventionTaskName.startsWith("run")) {
            return conventionTaskName;
        }
        return "run" + StringCapitalizationUtils.capitalize((String)conventionTaskName);
    }

    private static /* synthetic */ void lambda$null$10(Multimap sourceSetsByRunId, SourceSet sourceSet) {
        sourceSetsByRunId.put(((RunnableSourceSet)sourceSet.getExtensions().getByType(RunnableSourceSet.class)).getModIdentifier().get(), (Object)sourceSet);
    }
}

