/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import net.neoforged.gradle.common.tasks.FileCacheProviding;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class MinecraftVersionManifestFileCacheProvider
extends FileCacheProviding {
    public MinecraftVersionManifestFileCacheProvider() {
        this.getSelector().set(this.getMinecraftVersion().map(CacheFileSelector::forVersionJson));
        this.getMinecraftVersion().convention((Object)"+");
    }

    @TaskAction
    public void doDownload() {
        this.downloadVersionManifestToCache();
    }

    @Nested
    @Optional
    public abstract Property<String> getMinecraftVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLauncherManifest();

    private void downloadVersionManifestToCache() {
        String minecraftVersion = (String)this.getMinecraftVersion().get();
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(((RegularFile)this.getLauncherManifest().get()).getAsFile());){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            for (JsonElement e : json.getAsJsonArray("versions")) {
                String v = e.getAsJsonObject().get("id").getAsString();
                if (!Objects.equals(minecraftVersion, "+") && !v.equals(minecraftVersion)) continue;
                this.downloadJsonTo(e.getAsJsonObject().get("url").getAsString());
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the launcher manifest", e);
        }
        throw new IllegalStateException("Could not find the correct version json for version: " + minecraftVersion);
    }
}

