/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Objects;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import net.neoforged.gradle.util.HashFunction;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="This is an abstract underlying task which provides defaults and systems for caching game artifacts.")
public abstract class FileCacheProviding
extends NeoGradleBase
implements WithOutput,
WithWorkspace {
    protected FileCacheProviding() {
        this.getFileCache().set(this.getSelector().map(selector -> this.getLayout().getProjectDirectory().dir(".gradle/caches/minecraft").dir(selector.getCacheDirectory())));
        this.getFileCache().finalizeValueOnRead();
        this.getIsOffline().set((Object)this.getProject().getGradle().getStartParameter().isOffline());
        this.getOutputFileName().set(this.getSelector().map(CacheFileSelector::getCacheFileName));
        this.getOutput().set(this.getFileCache().flatMap(cacheDir -> this.getOutputFileName().map(arg_0 -> ((Directory)cacheDir).file(arg_0))));
    }

    @Internal
    public abstract DirectoryProperty getFileCache();

    @Nested
    public abstract Property<CacheFileSelector> getSelector();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLauncherJson();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getVersionManifest();

    @Optional
    @Input
    public abstract Property<Boolean> getIsOffline();

    protected void downloadJsonTo(String url) {
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        FileDownloadingUtils.downloadThrowing((Boolean)this.getIsOffline().get(), new FileDownloadingUtils.DownloadInfo(url, null, "json", null, null), output);
    }

    protected void doDownloadVersionDownloadToCache(String artifact, String potentialError, File versionManifest) {
        try (FileReader reader = new FileReader(versionManifest);){
            String fileHash;
            File output = ((RegularFile)this.getOutput().get()).getAsFile();
            Gson gson = new Gson();
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject(artifact);
            String url = artifactInfo.get("url").getAsString();
            String hash = artifactInfo.get("sha1").getAsString();
            String version = json.getAsJsonObject().get("id").getAsString();
            FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(url, hash, "jar", version, artifact);
            if (output.exists() && (fileHash = HashFunction.SHA1.hash(output)).equals(hash)) {
                return;
            }
            FileDownloadingUtils.downloadTo((Boolean)this.getIsOffline().get(), info, output);
        }
        catch (IOException e) {
            throw new RuntimeException(potentialError, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String resolveVersion(String gameVersion, File launcherMetadata) {
        if (!Objects.equals(gameVersion, "+")) {
            return gameVersion;
        }
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(launcherMetadata);){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            Iterator iterator = json.getAsJsonArray("versions").iterator();
            if (!iterator.hasNext()) throw new IllegalStateException("Could not find the correct version json.");
            JsonElement e = (JsonElement)iterator.next();
            String string = e.getAsJsonObject().get("id").getAsString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the launcher manifest", e);
        }
    }
}

