/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedDirectory;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedDirectoryFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFileRef;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedRegularFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeData;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class RuntimeDataImpl
implements RuntimeData {
    private final ProviderFactory providerFactory;

    @Inject
    public RuntimeDataImpl(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public Provider<File> get(String key) {
        return this.getFiles().map(files -> {
            Optional<NamedFileRef> namedFile = files.stream().filter(f -> f.getName().equals(key)).findFirst();
            return namedFile.map(NamedFileRef::getFile).orElse(null);
        });
    }

    public Provider<File> getOrDefault(String key, Provider<File> defaultProvider) {
        return this.get(key).orElse(defaultProvider);
    }

    public Provider<Map<String, Provider<File>>> asMap() {
        Provider filesProvider = this.getFiles().map(files -> files.stream().collect(Collectors.toMap(NamedFileRef::getName, namedFiles -> this.providerFactory.provider(() -> ((NamedFileRef)namedFiles).getFile()), (a, b) -> b, HashMap::new)));
        return filesProvider;
    }

    public void putFile(String input, Provider<File> fileProvider) {
        this.getFiles().add(fileProvider.map(file -> new NamedFile(input, file)));
    }

    public void putRegularFile(String input, Provider<RegularFile> fileProvider) {
        this.getFiles().add((Object)new NamedRegularFile(input, fileProvider));
    }

    public void putDirectoryFile(String input, Provider<File> fileProvider) {
        this.getFiles().add(fileProvider.map(file -> new NamedDirectoryFile(input, file)));
    }

    public void putDirectory(String input, Provider<Directory> fileProvider) {
        this.getFiles().add((Object)new NamedDirectory(input, fileProvider));
    }

    public void putAllFiles(Map<String, File> files) {
        files.forEach((key, file) -> this.getFiles().add(this.providerFactory.provider(() -> new NamedFile(key, file))));
    }

    public void putAllDirectories(Map<String, File> files) {
        files.forEach((key, file) -> this.getFiles().add(this.providerFactory.provider(() -> new NamedDirectoryFile(key, file))));
    }
}

