/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ListLibraries
extends DefaultRuntime {
    private static final Attributes.Name FORMAT = new Attributes.Name("Bundler-Format");

    public ListLibraries() {
        this.getServerBundleFile().fileProvider(this.getRuntimeArguments().map(arguments -> {
            if (!arguments.containsKey("bundle")) {
                return null;
            }
            return new File((String)((Provider)arguments.get("bundle")).get());
        }));
        this.getOutputFileName().set((Object)"libraries.txt");
    }

    @TaskAction
    public void run() throws Exception {
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        try (FileSystem bundleFs = !this.getServerBundleFile().isPresent() ? null : FileSystems.newFileSystem(((RegularFile)this.getServerBundleFile().get()).getAsFile().toPath(), ((Object)((Object)this)).getClass().getClassLoader());){
            Set<File> libraries = bundleFs == null ? this.downloadAndListJsonLibraries() : this.unpackAndListBundleLibraries(bundleFs);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));
            for (File file : libraries) {
                writer.println("-e=" + file.getAbsolutePath());
            }
            writer.flush();
            writer.close();
        }
    }

    private Set<String> listBundleLibraries(FileSystem bundleFs) throws IOException {
        Manifest mf;
        Path mfp = bundleFs.getPath("META-INF", "MANIFEST.MF");
        if (!Files.exists(mfp, new LinkOption[0])) {
            throw new RuntimeException("Input archive does not contain META-INF/MANIFEST.MF");
        }
        try (InputStream is = Files.newInputStream(mfp, new OpenOption[0]);){
            mf = new Manifest(is);
        }
        String format = mf.getMainAttributes().getValue(FORMAT);
        if (format == null) {
            throw new RuntimeException("Invalid bundler archive; missing format entry from manifest");
        }
        if (!"1.0".equals(format)) {
            throw new RuntimeException("Unsupported bundler format " + format + "; only 1.0 is supported");
        }
        FileList libraries = FileList.read(bundleFs.getPath("META-INF", "libraries.list"));
        HashSet<String> artifacts = new HashSet<String>();
        for (FileList.Entry entry : libraries.entries) {
            artifacts.add(entry.path);
        }
        return artifacts;
    }

    private Set<PathAndUrl> listDownloadJsonLibraries() throws IOException {
        Gson gson = new Gson();
        FileReader reader = new FileReader((File)this.getDownloadedVersionJsonFile().getAsFile().get());
        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        ((Reader)reader).close();
        HashSet<PathAndUrl> artifacts = new HashSet<PathAndUrl>();
        for (JsonElement libElement : json.getAsJsonArray("libraries")) {
            JsonObject downloads;
            JsonObject library = libElement.getAsJsonObject();
            if (!library.has("downloads") || !(downloads = library.get("downloads").getAsJsonObject()).has("artifact")) continue;
            JsonObject artifact = downloads.getAsJsonObject("artifact");
            artifacts.add(new PathAndUrl(artifact.get("path").getAsString(), artifact.get("url").getAsString()));
        }
        return artifacts;
    }

    private Set<File> unpackAndListBundleLibraries(FileSystem bundleFs) throws IOException {
        File outputDir = ((Directory)this.getOutputDirectory().get()).getAsFile();
        Set<String> libraryPaths = this.listBundleLibraries(bundleFs);
        return libraryPaths.stream().map(path -> String.format("META-INF/libraries/%s", path)).map(path -> {
            File output = new File(outputDir, (String)path);
            try (InputStream stream = Files.newInputStream(bundleFs.getPath((String)path, new String[0]), new OpenOption[0]);){
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)output);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return output;
        }).collect(Collectors.toSet());
    }

    private Set<File> downloadAndListJsonLibraries() throws IOException {
        Set<PathAndUrl> libraryCoordinates = this.listDownloadJsonLibraries();
        File outputDirectory = ((Directory)this.getOutputDirectory().get()).getAsFile();
        HashSet<File> result = new HashSet<File>();
        for (PathAndUrl libraryCoordinate : libraryCoordinates) {
            File outputFile = new File(outputDirectory, libraryCoordinate.path);
            FileUtils.copyInputStreamToFile((InputStream)new URL(libraryCoordinate.url).openStream(), (File)outputFile);
            result.add(outputFile);
        }
        return result;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getServerBundleFile();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getDownloadedVersionJsonFile();

    private final class PathAndUrl {
        private final String path;
        private final String url;

        private PathAndUrl(String path, String url) {
            this.path = path;
            this.url = url;
        }

        public String getPath() {
            return this.path;
        }

        public String getUrl() {
            return this.url;
        }
    }

    private static class FileList {
        private final List<Entry> entries;

        private FileList(List<Entry> entries) {
            this.entries = entries;
        }

        static FileList read(Path path) throws IOException {
            ArrayList<Entry> ret = new ArrayList<Entry>();
            for (String line : Files.readAllLines(path)) {
                String[] pts = line.split("\t");
                if (pts.length != 3) {
                    throw new IllegalStateException("Invalid file list line: " + line);
                }
                ret.add(new Entry(pts[0], pts[1], pts[2]));
            }
            return new FileList(ret);
        }

        private static final class Entry {
            private final String hash;
            private final String id;
            private final String path;

            private Entry(String hash, String id, String path) {
                this.hash = hash;
                this.id = id;
                this.path = path;
            }

            public String hash() {
                return this.hash;
            }

            public String id() {
                return this.id;
            }

            public String path() {
                return this.path;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Entry that = (Entry)obj;
                return Objects.equals(this.hash, that.hash) && Objects.equals(this.id, that.id) && Objects.equals(this.path, that.path);
            }

            public int hashCode() {
                return Objects.hash(this.hash, this.id, this.path);
            }

            public String toString() {
                return "Entry[hash=" + this.hash + ", id=" + this.id + ", path=" + this.path + ']';
            }
        }
    }
}

