/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.srgutils.IMappingFile;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.util.CacheableIMappingFile;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@NotNull
public abstract class GenerateDebuggingMappings
extends DefaultRuntime {
    public GenerateDebuggingMappings() {
        this.getMappingsFile().convention(this.getMinecraftVersion().map(minecraftVersion -> ((MinecraftArtifactCache)this.getProject().getExtensions().getByType(MinecraftArtifactCache.class)).cacheVersionMappings(minecraftVersion.getFull(), DistributionType.CLIENT)).map(TransformerUtils.guard(IMappingFile::load)).map(CacheableIMappingFile::new));
        this.getOutputFileName().convention((Object)"mappings.zip");
    }

    @TaskAction
    public void generate() throws Exception {
        String cname;
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        IMappingFile mappingFile = (IMappingFile)this.getMappingsFile().get();
        TreeMap<String, String> fieldMappings = new TreeMap<String, String>();
        TreeMap<String, String> methodMappings = new TreeMap<String, String>();
        for (IMappingFile.IClass cls : mappingFile.getClasses()) {
            for (IMappingFile.IField fld : cls.getFields()) {
                String srgFieldName = fld.getOriginal();
                if (!srgFieldName.startsWith("field_") && !srgFieldName.startsWith("f_")) continue;
                fieldMappings.put(srgFieldName, fld.getMapped());
            }
            for (Object mtd : cls.getMethods()) {
                String srgMethodName = mtd.getOriginal();
                if (!srgMethodName.startsWith("func_") && !srgMethodName.startsWith("m_")) continue;
                methodMappings.put(srgMethodName, mtd.getMapped());
            }
        }
        String[] header = new String[]{"searge", "name", "side", "desc"};
        ArrayList<String[]> fields = new ArrayList<String[]>();
        ArrayList<String[]> methods = new ArrayList<String[]>();
        fields.add(header);
        methods.add(header);
        for (String name : fieldMappings.keySet()) {
            cname = (String)fieldMappings.get(name);
            fields.add(new String[]{name, cname, "2", ""});
        }
        for (String name : methodMappings.keySet()) {
            cname = (String)methodMappings.get(name);
            methods.add(new String[]{name, cname, "2", ""});
        }
        try (FileOutputStream fos = new FileOutputStream(output);
             ZipOutputStream out = new ZipOutputStream(fos);){
            FileUtils.addCsvToZip((String)"fields.csv", fields, (ZipOutputStream)out);
            FileUtils.addCsvToZip((String)"methods.csv", methods, (ZipOutputStream)out);
        }
    }

    @Input
    public abstract Property<CacheableIMappingFile> getMappingsFile();
}

