/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.runs.run.DependencyHandlerImpl;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.type.RunAdapter;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class RunImpl
implements ConfigurableDSLElement<Run>,
Run {
    private final Project project;
    private final String name;
    private ListProperty<String> jvmArguments;
    private MapProperty<String, String> environmentVariables;
    private ListProperty<String> programArguments;
    private MapProperty<String, String> systemProperties;
    private final Set<TaskProvider<? extends Task>> dependencies = Sets.newHashSet();

    @Inject
    public RunImpl(Project project, String name) {
        this.project = project;
        this.name = name;
        this.jvmArguments = this.project.getObjects().listProperty(String.class);
        this.environmentVariables = this.project.getObjects().mapProperty(String.class, String.class);
        this.programArguments = this.project.getObjects().listProperty(String.class);
        this.systemProperties = this.project.getObjects().mapProperty(String.class, String.class);
        this.getIsSingleInstance().convention((Object)true);
        this.getIsClient().convention((Object)false);
        this.getIsServer().convention((Object)false);
        this.getIsDataGenerator().convention((Object)false);
        this.getIsGameTest().convention((Object)false);
        this.getShouldBuildAllProjects().convention((Object)false);
        this.getDependencies().convention(project.getObjects().newInstance(DependencyHandlerImpl.class, new Object[]{project}));
        this.getConfigureAutomatically().convention((Object)true);
        this.getConfigureFromTypeWithName().convention((Provider)this.getConfigureAutomatically());
        this.getConfigureFromDependencies().convention((Provider)this.getConfigureAutomatically());
        this.getWorkingDirectory().convention(project.getLayout().getProjectDirectory().dir("runs").dir(this.getName()));
    }

    public Project getProject() {
        return this.project;
    }

    public final String getName() {
        return this.name;
    }

    public MapProperty<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void overrideEnvironmentVariables(MapProperty<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public abstract Property<String> getMainClass();

    public abstract Property<Boolean> getShouldBuildAllProjects();

    public ListProperty<String> getProgramArguments() {
        return this.programArguments;
    }

    public void overrideProgramArguments(ListProperty<String> programArguments) {
        this.programArguments = programArguments;
    }

    public ListProperty<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public void overrideJvmArguments(ListProperty<String> args) {
        this.jvmArguments = args;
    }

    public MapProperty<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void overrideSystemProperties(MapProperty<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Internal
    public Set<TaskProvider<? extends Task>> getTaskDependencies() {
        return ImmutableSet.copyOf(this.dependencies);
    }

    public final void configure() {
        this.configure(this.getName());
    }

    public final void configure(@NotNull String name) {
        this.getConfigureFromTypeWithName().set((Object)false);
        ProjectUtils.afterEvaluate(this.getProject(), () -> this.project.getExtensions().configure("runTypes", types -> {
            if (types.getNames().contains(name)) {
                this.configureInternally((RunType)types.getByName(name));
            }
        }));
    }

    public final void configure(@NotNull RunType runType) {
        this.getConfigureFromTypeWithName().set((Object)false);
        ProjectUtils.afterEvaluate(this.getProject(), () -> this.configureInternally(runType));
    }

    public void configure(@NotNull Provider<RunType> typeProvider) {
        this.configure((RunType)typeProvider.get());
    }

    @SafeVarargs
    public final void dependsOn(TaskProvider<? extends Task> ... tasks) {
        this.dependencies.addAll(Arrays.asList(tasks));
    }

    public void configureInternally(@NotNull RunType spec) {
        this.getEnvironmentVariables().putAll((Provider)spec.getEnvironmentVariables());
        this.getMainClass().convention((Provider)spec.getMainClass());
        this.getProgramArguments().addAll((Provider)spec.getArguments());
        this.getJvmArguments().addAll((Provider)spec.getJvmArguments());
        this.getIsSingleInstance().convention((Provider)spec.getIsSingleInstance());
        this.getSystemProperties().putAll((Provider)spec.getSystemProperties());
        this.getIsClient().convention((Provider)spec.getIsClient());
        this.getIsServer().convention((Provider)spec.getIsServer());
        this.getIsDataGenerator().convention((Provider)spec.getIsDataGenerator());
        this.getIsGameTest().convention((Provider)spec.getIsGameTest());
        this.getClasspath().from(new Object[]{spec.getClasspath()});
        if (spec.getRunAdapter().isPresent()) {
            ((RunAdapter)spec.getRunAdapter().get()).adapt((Run)this);
        }
    }

    @NotNull
    public List<String> realiseJvmArguments() {
        ArrayList<String> args = new ArrayList<String>((Collection)this.getJvmArguments().get());
        ((Map)this.getSystemProperties().get()).forEach((key, value) -> args.add(String.format("-D%s=%s", key, value)));
        return args;
    }
}

