/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.ide;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import net.neoforged.elc.configs.GradleLaunchConfig;
import net.neoforged.elc.configs.JavaApplicationLaunchConfig;
import net.neoforged.elc.configs.LaunchConfig;
import net.neoforged.elc.configs.LaunchGroup;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.runs.ide.extensions.IdeaRunExtensionImpl;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.extensions.ProjectHolder;
import net.neoforged.gradle.dsl.common.runs.ide.extensions.IdeaRunExtension;
import net.neoforged.gradle.dsl.common.runs.idea.extensions.IdeaRunsExtension;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.jetbrains.gradle.ext.Application;
import org.jetbrains.gradle.ext.GradleTask;
import org.jetbrains.gradle.ext.Make;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.RunConfigurationContainer;
import org.jetbrains.gradle.ext.ShortenCommandLine;

public class IdeRunIntegrationManager {
    private static final IdeRunIntegrationManager INSTANCE = new IdeRunIntegrationManager();

    public static IdeRunIntegrationManager getInstance() {
        return INSTANCE;
    }

    private IdeRunIntegrationManager() {
    }

    public void setup(Project project) {
        project.getExtensions().configure("runs", runs -> runs.configureEach(run -> run.getExtensions().create(IdeaRunExtension.class, "idea", IdeaRunExtensionImpl.class, new Object[]{project, run})));
        Project rootProject = project.getRootProject();
        IdeaModel ideaModel = (IdeaModel)rootProject.getExtensions().getByType(IdeaModel.class);
        IdeaProject ideaProject = ideaModel.getProject();
        ExtensionAware extensionAware = (ExtensionAware)ideaProject;
        if (extensionAware.getExtensions().findByType(IdeaRunsExtension.class) == null) {
            extensionAware.getExtensions().create("runs", IdeaRunsExtension.class, new Object[]{project});
        }
    }

    public void apply(Project project) {
        IdeManagementExtension ideManager = (IdeManagementExtension)project.getExtensions().getByType(IdeManagementExtension.class);
        project.afterEvaluate(evaluatedProject -> ideManager.apply(new RunsImportAction()));
    }

    private static final class RunsImportAction
    implements IdeManagementExtension.IdeImportAction {
        private RunsImportAction() {
        }

        @Override
        public void idea(Project project, IdeaModel idea, ProjectSettings ideaExtension) {
            RunConfigurationContainer ideaRuns = (RunConfigurationContainer)((ExtensionAware)ideaExtension).getExtensions().getByType(RunConfigurationContainer.class);
            project.getExtensions().configure("runs", runs -> runs.getAsMap().forEach((name, run) -> {
                String runName = StringUtils.capitalize((String)(project.getName() + ": " + StringUtils.capitalize((String)name.replace(" ", "-"))));
                RunImpl runImpl = (RunImpl)run;
                IdeaRunExtension runIdeaConfig = (IdeaRunExtension)run.getExtensions().getByType(IdeaRunExtension.class);
                TaskProvider ideBeforeRunTask = project.getTasks().register(CommonRuntimeUtils.buildTaskName((String)"ideBeforeRun", (String)name), task -> {
                    for (SourceSet sourceSet : (List)run.getModSources().get()) {
                        Project sourceSetProject = ((ProjectHolder)sourceSet.getExtensions().getByType(ProjectHolder.class)).getProject();
                        task.dependsOn(new Object[]{sourceSetProject.getTasks().named(sourceSet.getProcessResourcesTaskName())});
                    }
                });
                if (!runImpl.getTaskDependencies().isEmpty()) {
                    ideBeforeRunTask.configure(task -> runImpl.getTaskDependencies().forEach(dep -> task.dependsOn(new Object[]{dep})));
                }
                ideaRuns.register(runName, Application.class, ideaRun -> {
                    ((Directory)runImpl.getWorkingDirectory().get()).getAsFile().mkdirs();
                    ideaRun.setMainClass((String)runImpl.getMainClass().get());
                    ideaRun.setWorkingDirectory(((Directory)runImpl.getWorkingDirectory().get()).getAsFile().getAbsolutePath());
                    ideaRun.setJvmArgs(String.join((CharSequence)" ", runImpl.realiseJvmArguments()));
                    ideaRun.moduleRef(project, (SourceSet)runIdeaConfig.getPrimarySourceSet().get());
                    ideaRun.setProgramParameters(String.join((CharSequence)" ", (Iterable)runImpl.getProgramArguments().get()));
                    ideaRun.setEnvs(RunsImportAction.adaptEnvironment(runImpl, RunsUtil::buildRunWithIdeaModClasses));
                    ideaRun.setShortenCommandLine(ShortenCommandLine.ARGS_FILE);
                    ideaRun.beforeRun(beforeRuns -> {
                        beforeRuns.create("Build", Make.class);
                        beforeRuns.create("Prepare Run", GradleTask.class, gradleTask -> gradleTask.setTask((Task)ideBeforeRunTask.get()));
                    });
                });
            }));
        }

        @Override
        public void eclipse(Project project, EclipseModel eclipse) {
            ProjectUtils.afterEvaluate(project, () -> project.getExtensions().configure("runs", runs -> runs.getAsMap().forEach((name, run) -> {
                String runName = StringUtils.capitalize((String)(project.getName() + " - " + StringUtils.capitalize((String)name.replace(" ", "-"))));
                RunImpl runImpl = (RunImpl)run;
                TaskProvider ideBeforeRunTask = project.getTasks().register(CommonRuntimeUtils.buildTaskName((String)"ideBeforeRun", (String)name), task -> {
                    for (SourceSet sourceSet : (List)run.getModSources().get()) {
                        Project sourceSetProject = ((ProjectHolder)sourceSet.getExtensions().getByType(ProjectHolder.class)).getProject();
                        task.dependsOn(new Object[]{sourceSetProject.getTasks().named(sourceSet.getProcessResourcesTaskName())});
                    }
                });
                if (!runImpl.getTaskDependencies().isEmpty()) {
                    ideBeforeRunTask.configure(task -> runImpl.getTaskDependencies().forEach(dep -> task.dependsOn(new Object[]{dep})));
                }
                try {
                    GradleLaunchConfig idePreRunTask = GradleLaunchConfig.builder((String)eclipse.getProject().getName()).tasks(new String[]{((Task)ideBeforeRunTask.get()).getName()}).build();
                    String gradleName = "Prepare " + runName;
                    RunsImportAction.writeLaunchToFile(project, gradleName, (LaunchConfig)idePreRunTask);
                    JavaApplicationLaunchConfig debugRun = JavaApplicationLaunchConfig.builder((String)eclipse.getProject().getName()).workingDirectory(((Directory)runImpl.getWorkingDirectory().get()).getAsFile().getAbsolutePath()).vmArgs(runImpl.realiseJvmArguments().toArray(new String[0])).args(((List)runImpl.getProgramArguments().get()).toArray(new String[0])).envVar(RunsImportAction.adaptEnvironment(runImpl, RunsUtil::buildRunWithEclipseModClasses)).useArgumentsFile().build((String)runImpl.getMainClass().get());
                    String debugName = "Run " + runName;
                    RunsImportAction.writeLaunchToFile(project, debugName, (LaunchConfig)debugRun);
                    RunsImportAction.writeLaunchToFile(project, runName, (LaunchConfig)LaunchGroup.builder().entry(LaunchGroup.entry((String)gradleName).enabled(true).adoptIfRunning(false).mode(LaunchGroup.Mode.RUN).action(LaunchGroup.Action.delay((int)2))).entry(LaunchGroup.entry((String)debugName).enabled(true).adoptIfRunning(false).mode(LaunchGroup.Mode.DEBUG).action(LaunchGroup.Action.waitForTermination())).build());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to write launch files: " + runName, e);
                }
            })));
        }

        private static void writeLaunchToFile(Project project, String fileName, LaunchConfig config) {
            File file = project.file((Object)String.format(".eclipse/configurations/%s.launch", fileName));
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file, false);){
                config.write((Writer)writer);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write launch file: " + fileName, e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to write launch file: " + fileName, e);
            }
        }

        private static Map<String, String> adaptEnvironment(RunImpl run, Function<ListProperty<SourceSet>, Provider<String>> modClassesProvider) {
            HashMap<String, String> environment = new HashMap<String, String>((Map)run.getEnvironmentVariables().get());
            environment.put("MOD_CLASSES", (String)modClassesProvider.apply((ListProperty<SourceSet>)run.getModSources()).get());
            return environment;
        }
    }
}

