/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import groovy.lang.GroovyObjectSupport;
import java.io.Serializable;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.minecraftforge.gdi.ProjectAssociatedDSLElement;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryReference;
import net.neoforged.gradle.dsl.common.util.ModuleReference;
import net.neoforged.gradle.util.ResolvedDependencyUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;

public abstract class IvyDummyRepositoryReference
implements ConfigurableDSLElement<IvyDummyRepositoryReference>,
RepositoryReference,
Serializable,
ProjectAssociatedDSLElement {
    private static final long serialVersionUID = 8472300128115908221L;
    private final transient Project project;
    private final String group;
    private final String name;
    private final String version;
    private final String classifier;
    private final String extension;

    @Inject
    public IvyDummyRepositoryReference(@NotNull Project project, String group, String name, String version, String classifier, String extension) {
        this.project = project;
        this.group = group;
        this.name = name;
        this.version = version;
        this.classifier = classifier.isEmpty() ? null : classifier;
        this.extension = extension.isEmpty() ? null : extension;
    }

    public Project getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IvyDummyRepositoryReference that = (IvyDummyRepositoryReference)obj;
        return Objects.equals(this.group, that.group) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name, this.version, this.classifier, this.extension);
    }

    public String toString() {
        return "IvyDummyRepositoryEntryDependency[group=" + this.group + ", name=" + this.name + ", version=" + this.version + ", classifier=" + this.classifier + ", extension=" + this.extension + ']';
    }

    @NotNull
    public ModuleReference toModuleReference() {
        return new ModuleReference(this.getGroup(), this.getName(), this.getVersion(), this.getExtension(), this.getClassifier());
    }

    public Dependency toGradle(Project project) {
        throw new UnsupportedOperationException("Can not create a gradle dependency from a raw reference.");
    }

    public static abstract class Builder
    extends GroovyObjectSupport
    implements RepositoryReference.Builder<Builder, IvyDummyRepositoryReference> {
        private final Project project;
        private String group;
        private String name;
        private String version;
        private String classifier;
        private String extension;

        @Inject
        public Builder(Project project) {
            this.project = project;
        }

        public static Builder create(Project project) {
            return (Builder)((Object)project.getObjects().newInstance(Builder.class, new Object[]{project}));
        }

        public Project getProject() {
            return this.project;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder setExtension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder from(ModuleDependency externalModuleDependency) {
            this.setGroup(externalModuleDependency.getGroup());
            this.setName(externalModuleDependency.getName());
            this.setVersion(externalModuleDependency.getVersion());
            if (!externalModuleDependency.getArtifacts().isEmpty()) {
                DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
                this.setClassifier(artifact.getClassifier());
                this.setExtension(artifact.getExtension());
            }
            return this;
        }

        public Builder from(ResolvedDependency externalModuleDependency) {
            this.setGroup(externalModuleDependency.getModuleGroup());
            this.setName(externalModuleDependency.getModuleName());
            this.setVersion(externalModuleDependency.getModuleVersion());
            this.setExtension(ResolvedDependencyUtils.getExtension((ResolvedDependency)externalModuleDependency));
            this.setClassifier(ResolvedDependencyUtils.getClassifier((ResolvedDependency)externalModuleDependency));
            return this;
        }

        public Builder but() {
            return Builder.create(this.project).setGroup(this.group).setName(this.name).setVersion(this.version).setClassifier(this.classifier).setExtension(this.extension);
        }

        public IvyDummyRepositoryReference build() {
            return (IvyDummyRepositoryReference)this.project.getObjects().newInstance(IvyDummyRepositoryReference.class, new Object[]{this.project, this.group, this.name, this.version, this.classifier == null ? "" : this.classifier, this.extension == null ? "" : this.extension});
        }
    }
}

