/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.tasks.MinecraftLauncherFileCacheProvider;
import net.neoforged.gradle.common.tasks.MinecraftVersionManifestFileCacheProvider;
import net.neoforged.gradle.common.util.FileCacheUtils;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.common.util.MinecraftArtifactType;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.util.HashFunction;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class MinecraftArtifactCacheExtension
implements ConfigurableDSLElement<MinecraftArtifactCache>,
MinecraftArtifactCache {
    private final Project project;
    private final Map<CacheFileSelector, File> cacheFiles;
    private final Map<TaskKey, Map<GameArtifact, TaskProvider<? extends WithOutput>>> tasks = new ConcurrentHashMap<TaskKey, Map<GameArtifact, TaskProvider<? extends WithOutput>>>();

    @Inject
    public MinecraftArtifactCacheExtension(Project project) {
        this.project = project;
        this.cacheFiles = new ConcurrentHashMap<CacheFileSelector, File>();
        this.getCacheDirectory().fileProvider(project.provider(() -> new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraft")));
        this.getCacheDirectory().finalizeValueOnRead();
    }

    public Project getProject() {
        return this.project;
    }

    public abstract DirectoryProperty getCacheDirectory();

    public final Map<CacheFileSelector, File> getCacheFiles() {
        return ImmutableMap.copyOf(this.cacheFiles);
    }

    public final Map<GameArtifact, File> cacheGameVersion(String gameVersion, DistributionType side) {
        gameVersion = this.resolveVersion(gameVersion);
        EnumMap<GameArtifact, File> result = new EnumMap<GameArtifact, File>(GameArtifact.class);
        String finalGameVersion = gameVersion;
        GameArtifact.LAUNCHER_MANIFEST.doWhenRequired(side, () -> result.put(GameArtifact.LAUNCHER_MANIFEST, this.cacheLauncherMetadata()));
        GameArtifact.LAUNCHER_MANIFEST.doWhenRequired(side, () -> result.put(GameArtifact.LAUNCHER_MANIFEST, this.cacheLauncherMetadata()));
        GameArtifact.VERSION_MANIFEST.doWhenRequired(side, () -> result.put(GameArtifact.VERSION_MANIFEST, this.cacheVersionManifest(finalGameVersion)));
        GameArtifact.CLIENT_JAR.doWhenRequired(side, () -> result.put(GameArtifact.CLIENT_JAR, this.cacheVersionArtifact(finalGameVersion, DistributionType.CLIENT)));
        GameArtifact.SERVER_JAR.doWhenRequired(side, () -> result.put(GameArtifact.SERVER_JAR, this.cacheVersionArtifact(finalGameVersion, DistributionType.SERVER)));
        GameArtifact.CLIENT_MAPPINGS.doWhenRequired(side, () -> result.put(GameArtifact.CLIENT_MAPPINGS, this.cacheVersionMappings(finalGameVersion, DistributionType.CLIENT)));
        GameArtifact.SERVER_MAPPINGS.doWhenRequired(side, () -> result.put(GameArtifact.SERVER_MAPPINGS, this.cacheVersionMappings(finalGameVersion, DistributionType.SERVER)));
        return result;
    }

    @NotNull
    public final Map<GameArtifact, TaskProvider<? extends WithOutput>> cacheGameVersionTasks(Project project, String gameVersion, DistributionType side) {
        gameVersion = this.resolveVersion(gameVersion);
        TaskKey key = new TaskKey(project, gameVersion, side);
        String finalGameVersion = gameVersion;
        return this.tasks.computeIfAbsent(key, k -> {
            EnumMap results = new EnumMap(GameArtifact.class);
            TaskProvider<MinecraftLauncherFileCacheProvider> launcher = FileCacheUtils.createLauncherMetadataFileCacheProvidingTask(project);
            TaskProvider<MinecraftVersionManifestFileCacheProvider> manifest = FileCacheUtils.createVersionManifestFileCacheProvidingTask(project, finalGameVersion, launcher);
            GameArtifact.LAUNCHER_MANIFEST.doWhenRequired(side, () -> results.put(GameArtifact.LAUNCHER_MANIFEST, launcher));
            GameArtifact.VERSION_MANIFEST.doWhenRequired(side, () -> results.put(GameArtifact.VERSION_MANIFEST, manifest));
            GameArtifact.CLIENT_JAR.doWhenRequired(side, () -> results.put(GameArtifact.CLIENT_JAR, FileCacheUtils.createArtifactFileCacheProvidingTask(project, finalGameVersion, DistributionType.CLIENT, MinecraftArtifactType.EXECUTABLE, manifest, results.values())));
            GameArtifact.SERVER_JAR.doWhenRequired(side, () -> results.put(GameArtifact.SERVER_JAR, FileCacheUtils.createArtifactFileCacheProvidingTask(project, finalGameVersion, DistributionType.SERVER, MinecraftArtifactType.EXECUTABLE, manifest, results.values())));
            GameArtifact.CLIENT_MAPPINGS.doWhenRequired(side, () -> results.put(GameArtifact.CLIENT_MAPPINGS, FileCacheUtils.createArtifactFileCacheProvidingTask(project, finalGameVersion, DistributionType.CLIENT, MinecraftArtifactType.MAPPINGS, manifest, results.values())));
            GameArtifact.SERVER_MAPPINGS.doWhenRequired(side, () -> results.put(GameArtifact.SERVER_MAPPINGS, FileCacheUtils.createArtifactFileCacheProvidingTask(project, finalGameVersion, DistributionType.SERVER, MinecraftArtifactType.MAPPINGS, manifest, results.values())));
            return results;
        });
    }

    public final File cacheLauncherMetadata() {
        return this.cache("https://piston-meta.mojang.com/mc/game/version_manifest.json", CacheFileSelector.launcherMetadata());
    }

    public final File cacheVersionManifest(String gameVersion) {
        gameVersion = this.resolveVersion(gameVersion);
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionJson((String)gameVersion);
        String finalGameVersion = gameVersion;
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionManifestToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), finalGameVersion));
    }

    public final File cacheVersionArtifact(String gameVersion, DistributionType side) {
        gameVersion = this.resolveVersion(gameVersion);
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionJar((String)gameVersion, (String)side.getName());
        String finalGameVersion = gameVersion;
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionArtifactToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), finalGameVersion, side));
    }

    public final File cacheVersionMappings(String gameVersion, DistributionType side) {
        gameVersion = this.resolveVersion(gameVersion);
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionMappings((String)gameVersion, (String)side.getName());
        String finalGameVersion = gameVersion;
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionMappingsToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), finalGameVersion, side));
    }

    public final File cache(URL url, CacheFileSelector selector) {
        return this.cache(url.toString(), selector);
    }

    public final File cache(String url, CacheFileSelector selector) {
        return this.cacheFiles.computeIfAbsent(selector, cacheKey -> this.downloadJsonToCache(this.project, url, (File)this.getCacheDirectory().getAsFile().get(), selector));
    }

    private File downloadVersionManifestToCache(Project project, File cacheDirectory, String minecraftVersion) {
        File manifestFile = new File(new File(cacheDirectory, CacheFileSelector.launcherMetadata().getCacheDirectory()), CacheFileSelector.launcherMetadata().getCacheFileName());
        Gson gson = new Gson();
        String url = null;
        try (FileReader reader = new FileReader(manifestFile);){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            for (JsonElement e : json.getAsJsonArray("versions")) {
                String v = e.getAsJsonObject().get("id").getAsString();
                if (!Objects.equals(minecraftVersion, "+") && !v.equals(minecraftVersion)) continue;
                url = e.getAsJsonObject().get("url").getAsString();
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the launcher manifest", e);
        }
        if (url == null) {
            throw new IllegalStateException("Could not find the correct version json for version: " + minecraftVersion);
        }
        return this.downloadJsonToCache(project, url, cacheDirectory, CacheFileSelector.forVersionJson((String)minecraftVersion));
    }

    private File downloadVersionArtifactToCache(Project project, File cacheDirectory, String minecraftVersion, DistributionType side) {
        minecraftVersion = this.resolveVersion(minecraftVersion);
        return this.doDownloadVersionDownloadToCache(project, cacheDirectory, minecraftVersion, side.getName(), CacheFileSelector.forVersionJar((String)minecraftVersion, (String)side.getName()), String.format("Failed to download game artifact %s for %s", side.getName(), minecraftVersion));
    }

    private File downloadVersionMappingsToCache(Project project, File cacheDirectory, String minecraftVersion, DistributionType side) {
        minecraftVersion = this.resolveVersion(minecraftVersion);
        return this.doDownloadVersionDownloadToCache(project, cacheDirectory, minecraftVersion, String.format("%s_mappings", side.getName()), CacheFileSelector.forVersionMappings((String)minecraftVersion, (String)side.getName()), String.format("Failed to download game mappings of %s for %s", side.getName(), minecraftVersion));
    }

    private File doDownloadVersionDownloadToCache(Project project, File cacheDirectory, String minecraftVersion, String artifact, CacheFileSelector cacheFileSelector, String potentialError) {
        minecraftVersion = this.resolveVersion(minecraftVersion);
        File versionManifestFile = this.cacheVersionManifest(minecraftVersion);
        try {
            String fileHash;
            Gson gson = new Gson();
            FileReader reader = new FileReader(versionManifestFile);
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject(artifact);
            String url = artifactInfo.get("url").getAsString();
            String hash = artifactInfo.get("sha1").getAsString();
            String version = json.getAsJsonObject().get("id").getAsString();
            FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(url, hash, "jar", version, artifact);
            File cacheFile = new File(new File(cacheDirectory, cacheFileSelector.getCacheDirectory()), cacheFileSelector.getCacheFileName());
            if (cacheFile.exists() && (fileHash = HashFunction.SHA1.hash(cacheFile)).equals(hash)) {
                return cacheFile;
            }
            FileDownloadingUtils.downloadTo(project.getGradle().getStartParameter().isOffline(), info, cacheFile);
            return cacheFile;
        }
        catch (IOException e) {
            throw new RuntimeException(potentialError, e);
        }
    }

    private File downloadJsonToCache(Project project, String url, File cacheDirectory, CacheFileSelector selector) {
        File cacheFile = new File(new File(cacheDirectory, selector.getCacheDirectory()), selector.getCacheFileName());
        this.downloadJsonTo(project, url, cacheFile);
        return cacheFile;
    }

    private void downloadJsonTo(Project project, String url, File file) {
        FileDownloadingUtils.downloadThrowing(project.getGradle().getStartParameter().isOffline(), new FileDownloadingUtils.DownloadInfo(url, null, "json", null, null), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveVersion(String gameVersion) {
        if (!Objects.equals(gameVersion, "+")) {
            return gameVersion;
        }
        File launcherMetadata = this.cacheLauncherMetadata();
        Gson gson = new Gson();
        Object url = null;
        try (FileReader reader = new FileReader(launcherMetadata);){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            Iterator iterator = json.getAsJsonArray("versions").iterator();
            if (!iterator.hasNext()) throw new IllegalStateException("Could not find the correct version json.");
            JsonElement e = (JsonElement)iterator.next();
            String string = e.getAsJsonObject().get("id").getAsString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the launcher manifest", e);
        }
    }

    private static final class TaskKey {
        private final Project project;
        private final String gameVersion;
        private final DistributionType type;

        private TaskKey(Project project, String gameVersion, DistributionType type) {
            this.project = project;
            this.gameVersion = gameVersion;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskKey taskKey = (TaskKey)o;
            return Objects.equals(this.project, taskKey.project) && Objects.equals(this.gameVersion, taskKey.gameVersion) && this.type == taskKey.type;
        }

        public int hashCode() {
            return Objects.hash(this.project, this.gameVersion, this.type);
        }
    }
}

