/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.io.File;
import net.neoforged.gradle.common.tasks.DownloadingTask;
import net.neoforged.gradle.dsl.common.tasks.WithJavaVersion;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;

public abstract class JavaRuntimeTask
extends DownloadingTask
implements WithJavaVersion {
    public JavaRuntimeTask() {
        this.getJavaVersion().convention((Provider)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        this.getJavaLauncher().convention(this.getJavaToolChain().flatMap(toolChain -> {
            if (!this.getJavaVersion().isPresent()) {
                return toolChain.launcherFor((JavaToolchainSpec)new CurrentJvmToolchainSpec(this.getObjectFactory()));
            }
            return toolChain.launcherFor(spec -> spec.getLanguageVersion().set(this.getJavaVersion()));
        }));
        this.getJavaToolChain().convention(this.getProject().getExtensions().getByType(JavaToolchainService.class));
    }

    @Internal
    public abstract Property<JavaToolchainService> getJavaToolChain();

    @Nested
    @Optional
    public abstract Property<JavaLanguageVersion> getJavaVersion();

    @Internal
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Internal
    public Provider<String> getExecutablePath() {
        return this.getJavaLauncher().map(JavaLauncher::getExecutablePath).map(RegularFile::getAsFile).map(File::getAbsolutePath);
    }
}

