/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import net.neoforged.gradle.common.caching.CentralCacheService;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.runtime.tasks.action.DownloadFileAction;
import net.neoforged.gradle.common.util.FileCacheUtils;
import net.neoforged.gradle.common.util.SerializationUtils;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class DownloadAssets
extends DefaultRuntime {
    public DownloadAssets() {
        this.getAssetsDirectory().convention(FileCacheUtils.getAssetsCacheDirectory(this.getProject()).flatMap(assetsDir -> assetsDir.dir(this.getVersionJson().map(VersionJson::getId))).map(TransformerUtils.ensureExists()));
        this.getOutputDirectory().convention((Provider)this.getAssetsDirectory());
        this.getAssetIndex().convention((Object)"asset-index");
        this.getAssetIndexFileName().convention(this.getAssetIndex().map(index -> index + ".json"));
        this.getAssetIndexFile().convention(this.getRegularFileInOutputDirectory((Provider<String>)this.getAssetIndexFileName().map(name -> "indexes/" + name)));
        this.getVersionJson().convention(this.getVersionJsonFile().map(TransformerUtils.guard(file -> VersionJson.get(file.getAsFile()))));
        this.getAssetRepository().convention((Object)"https://resources.download.minecraft.net/");
        this.getIsOffline().convention((Object)this.getProject().getGradle().getStartParameter().isOffline());
    }

    @ServiceReference(value="ng_assets")
    public abstract Property<CentralCacheService> getAssetsCache();

    @TaskAction
    public void run() {
        this.downloadAssetIndex();
        this.downloadAssets();
    }

    private void downloadAssetIndex() {
        VersionJson json = (VersionJson)this.getVersionJson().get();
        VersionJson.AssetIndex assetIndexData = json.getAssetIndex();
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        executor.submit(DownloadFileAction.class, params -> {
            params.getUrl().set((Object)assetIndexData.getUrl().toString());
            params.getShouldValidateHash().set((Object)true);
            params.getSha1().set((Object)assetIndexData.getSha1());
            params.getOutputFile().set((Provider)this.getAssetIndexFile());
            params.getIsOffline().set(this.getIsOffline());
        });
        executor.await();
    }

    private void downloadAssets() {
        AssetIndex assetIndex = SerializationUtils.fromJson((File)this.getAssetIndexFile().getAsFile().get(), AssetIndex.class);
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        assetIndex.getObjects().values().stream().distinct().forEach(asset -> {
            Provider<File> assetFile = this.getFileInOutputDirectory(String.format("objects%s%s", File.separator, asset.getPath()));
            Provider assetUrl = this.getAssetRepository().map(repo -> repo.endsWith("/") ? repo : repo + "/").map(TransformerUtils.guard(repository -> repository + asset.getPath()));
            executor.submit(DownloadFileAction.class, params -> {
                params.getIsOffline().set(this.getIsOffline());
                params.getShouldValidateHash().set((Object)true);
                params.getOutputFile().fileProvider(assetFile);
                params.getUrl().set(assetUrl);
                params.getSha1().set((Object)asset.getHash());
            });
        });
        executor.await();
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getVersionJsonFile();

    @Input
    public abstract Property<VersionJson> getVersionJson();

    @Input
    public abstract Property<String> getAssetIndex();

    @Input
    public abstract Property<String> getAssetIndexFileName();

    @Input
    public abstract Property<String> getAssetRepository();

    @OutputFile
    public abstract RegularFileProperty getAssetIndexFile();

    @Input
    public abstract Property<Boolean> getIsOffline();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getAssetsDirectory();

    private static class Asset {
        private String hash;

        private Asset() {
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getPath() {
            return this.hash.substring(0, 2) + '/' + this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Asset)) {
                return false;
            }
            Asset asset = (Asset)o;
            return this.getHash().equals(asset.getHash());
        }

        public int hashCode() {
            return this.getHash().hashCode();
        }
    }

    private static class AssetIndex {
        private Map<String, Asset> objects = Maps.newHashMap();

        private AssetIndex() {
        }

        public Map<String, Asset> getObjects() {
            return this.objects;
        }

        public void setObjects(Map<String, Asset> objects) {
            this.objects = objects;
        }
    }
}

