/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming;

import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.gradle.common.runtime.extensions.RuntimesExtension;
import net.neoforged.gradle.common.runtime.naming.tasks.ApplyOfficialMappingsToCompiledJar;
import net.neoforged.gradle.common.runtime.naming.tasks.ApplyOfficialMappingsToSourceJar;
import net.neoforged.gradle.common.util.MappingUtils;
import net.neoforged.gradle.common.util.StreamUtils;
import net.neoforged.gradle.common.util.TaskDependencyUtils;
import net.neoforged.gradle.common.util.exceptions.MultipleDefinitionsFoundException;
import net.neoforged.gradle.common.util.exceptions.NoDefinitionsFoundException;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.runtime.naming.TaskBuildingContext;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class OfficialNamingChannelConfigurator {
    private static final OfficialNamingChannelConfigurator INSTANCE = new OfficialNamingChannelConfigurator();

    public static OfficialNamingChannelConfigurator getInstance() {
        return INSTANCE;
    }

    private OfficialNamingChannelConfigurator() {
    }

    public void configure(Project project) {
        Minecraft minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        Property hasAcceptedLicenseProperty = project.getObjects().property(Boolean.class);
        mappingsExtension.getExtensions().add(TypeOf.typeOf(Property.class), "acceptMojangEula", (Object)hasAcceptedLicenseProperty);
        hasAcceptedLicenseProperty.convention((Object)false);
        minecraftExtension.getNamingChannels().register("official", namingChannelProvider -> {
            namingChannelProvider.getApplySourceMappingsTaskBuilder().set(this::buildApplySourceMappingTask);
            namingChannelProvider.getApplyCompiledMappingsTaskBuilder().set(this::buildApplyCompiledMappingsTask);
            namingChannelProvider.getHasAcceptedLicense().convention(project.provider(() -> (Boolean)((Property)mappingsExtension.getExtensions().getByName("acceptMojangEula")).get()));
            namingChannelProvider.getLicenseText().set(this.getLicenseText(project));
        });
        minecraftExtension.getMappings().getChannel().convention((Provider)minecraftExtension.getNamingChannels().named("official"));
    }

    @NotNull
    private TaskProvider<? extends Runtime> buildApplySourceMappingTask(@NotNull TaskBuildingContext context) {
        String applyTaskName = (String)context.getTaskNameBuilder().apply("applyOfficialMappings");
        return context.getProject().getTasks().register(applyTaskName, ApplyOfficialMappingsToSourceJar.class, applyOfficialMappingsToSourceJar -> {
            String mappingVersion = MappingUtils.getVersionOrMinecraftVersion((Map)context.getMappingVersion().get());
            applyOfficialMappingsToSourceJar.setGroup("mappings/official");
            applyOfficialMappingsToSourceJar.setDescription(String.format("Applies the Official mappings for version %s.", mappingVersion));
            applyOfficialMappingsToSourceJar.getClientMappingsFile().set(context.getGameArtifactTask(GameArtifact.CLIENT_MAPPINGS).flatMap(OutputSpecification::getOutput));
            applyOfficialMappingsToSourceJar.getServerMappingsFile().set(context.getGameArtifactTask(GameArtifact.SERVER_MAPPINGS).flatMap(OutputSpecification::getOutput));
            applyOfficialMappingsToSourceJar.getInput().set(context.getInputTask().flatMap(OutputSpecification::getOutput));
            applyOfficialMappingsToSourceJar.dependsOn(new Object[]{context.getGameArtifactTask(GameArtifact.CLIENT_MAPPINGS)});
            applyOfficialMappingsToSourceJar.dependsOn(new Object[]{context.getGameArtifactTask(GameArtifact.SERVER_MAPPINGS)});
            applyOfficialMappingsToSourceJar.getStepName().set((Object)"applyOfficialMappings");
        });
    }

    @NotNull
    private TaskProvider<? extends Runtime> buildApplyCompiledMappingsTask(@NotNull TaskBuildingContext context) {
        String ApplyTaskName = CommonRuntimeUtils.buildTaskName((TaskProvider)context.getInputTask(), (String)"deobfuscate");
        TaskProvider applyTask = context.getProject().getTasks().register(ApplyTaskName, ApplyOfficialMappingsToCompiledJar.class, task -> {
            if (!context.getRuntimeDefinition().isPresent()) {
                throw new IllegalArgumentException("Cannot apply compiled mappings without a runtime definition");
            }
            TaskProvider librariesTask = context.getLibrariesTask();
            if (librariesTask == null) {
                throw new IllegalArgumentException("Cannot apply compiled mappings without a libraries task");
            }
            task.setGroup("mappings/official");
            task.setDescription("Applies the Official mappings and unobfuscates a compiled jar");
            task.getMinecraftVersion().set(context.getMappingVersion().flatMap(versionData -> {
                if (versionData.containsKey("version") || versionData.containsKey("minecraft")) {
                    return context.getProject().provider(() -> CacheableMinecraftVersion.from((String)MappingUtils.getVersionOrMinecraftVersion(versionData), (Project)context.getProject()));
                }
                return context.getInputTask().map(t -> {
                    try {
                        return CacheableMinecraftVersion.from((String)MappingUtils.getVersionOrMinecraftVersion(TaskDependencyUtils.extractRuntimeDefinition(context.getProject(), (Task)t).getMappingVersionData()), (Project)context.getProject());
                    }
                    catch (MultipleDefinitionsFoundException e) {
                        throw new RuntimeException("Could not determine the runtime definition to use. Multiple definitions were found: " + e.getDefinitions().stream().map(r1 -> r1.getSpecification().getVersionedName()).collect(Collectors.joining(", ")), e);
                    }
                    catch (NoDefinitionsFoundException e) {
                        throw new RuntimeException("Could not determine the runtime definition to use. Within the renaming context, there is none defined!", e);
                    }
                });
            }));
            task.getInput().set(context.getInputTask().flatMap(OutputSpecification::getOutput));
            task.getLibraries().set(librariesTask.flatMap(OutputSpecification::getOutput));
            task.getMappings().set(context.getGameArtifactTask(GameArtifact.CLIENT_MAPPINGS).flatMap(OutputSpecification::getOutput));
            task.dependsOn(new Object[]{context.getInputTask()});
            task.dependsOn(new Object[]{librariesTask});
        });
        context.getInputTask().configure(task -> task.finalizedBy(new Object[]{applyTask}));
        return applyTask;
    }

    @NotNull
    private Provider<String> getLicenseText(Project project) {
        MinecraftArtifactCache cacheExtension = (MinecraftArtifactCache)project.getExtensions().getByType(MinecraftArtifactCache.class);
        return project.provider(() -> ((RuntimesExtension)project.getExtensions().getByType(RuntimesExtension.class)).getAllDefinitions()).map(runtimes -> runtimes.stream().map(runtime -> runtime.getSpecification().getMinecraftVersion()).distinct().collect(Collectors.toList())).map(minecraftVersions -> {
            if (minecraftVersions.isEmpty()) {
                return Collections.emptyList();
            }
            return minecraftVersions.stream().map(version -> cacheExtension.cacheVersionMappings(version, DistributionType.CLIENT)).collect(Collectors.toList());
        }).map(mappingFiles -> {
            if (mappingFiles.isEmpty()) {
                return Collections.emptyList();
            }
            return mappingFiles.stream().map(mappingFile -> {
                try (Stream<String> lines = Files.lines(mappingFile.toPath());){
                    String string = StreamUtils.takeWhile(lines, line -> line.startsWith("#")).map(l -> l.substring(1).trim()).collect(Collectors.joining("\n"));
                    return string;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to read the mapping license from: %s", mappingFile.getAbsolutePath()), e);
                }
            }).distinct().collect(Collectors.toList());
        }).map(licenses -> {
            if (licenses.isEmpty()) {
                return "No license text found";
            }
            return licenses.stream().distinct().collect(Collectors.joining("\n\n"));
        });
    }
}

