/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.subsystems;

import java.util.Arrays;
import java.util.Locale;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DecompilerLogLevel;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.provider.ProviderFactory;

public abstract class SubsystemsExtension
implements ConfigurableDSLElement<Subsystems>,
Subsystems {
    private static final String PROPERTY_PREFIX = "neogradle.subsystems.";
    private final Project project;

    @Inject
    public SubsystemsExtension(Project project) {
        this.project = project;
        ProviderFactory providers = project.getProviders();
        this.getDecompiler().getMaxMemory().convention(providers.gradleProperty("neogradle.subsystems.decompiler.maxMemory"));
        this.getDecompiler().getMaxThreads().convention(providers.gradleProperty("neogradle.subsystems.decompiler.maxThreads").map(Integer::parseUnsignedInt));
        this.getDecompiler().getLogLevel().convention(providers.gradleProperty("neogradle.subsystems.decompiler.logLevel").map(s -> {
            try {
                return DecompilerLogLevel.valueOf((String)s.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new GradleException("Unknown DecompilerLogLevel: " + s + ". Available options: " + Arrays.toString(DecompilerLogLevel.values()));
            }
        }));
        this.getDecompiler().getJvmArgs().convention(providers.gradleProperty("neogradle.subsystems.decompiler.jvmArgs").map(s -> Arrays.asList(s.split("\\s+"))));
    }

    public Project getProject() {
        return this.project;
    }
}

