/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.gradle.common.extensions.repository.IvyDummyRepositoryEntry;
import org.gradle.api.artifacts.ComponentMetadataBuilder;
import org.gradle.api.artifacts.ComponentMetadataSupplier;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IvyDummyRepositoryMetadataSupplier
implements ComponentMetadataSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(IvyDummyRepositoryMetadataSupplier.class);
    private final Provider<Set<IvyDummyRepositoryEntry>> extensionProvider;
    private final Provider<Directory> rootDirectoryProvider;

    @Inject
    public IvyDummyRepositoryMetadataSupplier(Provider<Set<IvyDummyRepositoryEntry>> extensionProvider, Provider<Directory> rootDirectoryProvider) {
        this.extensionProvider = extensionProvider;
        this.rootDirectoryProvider = rootDirectoryProvider;
    }

    public void execute(ComponentMetadataSupplierDetails details) {
        ModuleComponentIdentifier id = details.getId();
        ComponentMetadataBuilder result = details.getResult();
        LOGGER.info("Preparing metadata for {}", (Object)id.getVersion());
        Optional<IvyDummyRepositoryEntry> entryCandidate = ((Set)this.extensionProvider.get()).stream().filter(entry -> entry.matches(id)).findFirst();
        if (!entryCandidate.isPresent()) {
            return;
        }
        try {
            Path artifactPath = entryCandidate.get().buildArtifactPath(((Directory)this.rootDirectoryProvider.get()).getAsFile().toPath());
            Files.createFile(artifactPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create dummy artifact!", e);
        }
        result.setStatus("Found");
        result.setStatusScheme((List)Lists.newArrayList((Object[])new String[]{"Found", "Not Found"}));
    }
}

