/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.runtime.naming.NamingChannelProvider;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public abstract class MinecraftExtension
implements ConfigurableDSLElement<Minecraft>,
Minecraft {
    private final Project project;
    private final AccessTransformers accessTransformers;
    private final NamedDomainObjectContainer<NamingChannel> namingChannelProviders;

    @Inject
    public MinecraftExtension(Project project) {
        this.project = project;
        this.accessTransformers = (AccessTransformers)project.getExtensions().getByType(AccessTransformers.class);
        this.namingChannelProviders = project.getObjects().domainObjectContainer(NamingChannel.class, name -> (NamingChannelProvider)project.getObjects().newInstance(NamingChannelProvider.class, new Object[]{project, name}));
        String baseName = project.getName().replace(":", "_");
        this.getModIdentifier().convention(project.provider(() -> {
            if (baseName.startsWith("_")) {
                return baseName.substring(1);
            }
            return baseName;
        }));
    }

    public Project getProject() {
        return this.project;
    }

    public NamedDomainObjectContainer<NamingChannel> getNamingChannels() {
        return this.namingChannelProviders;
    }

    public Mappings getMappings() {
        return (Mappings)this.project.getExtensions().getByType(Mappings.class);
    }

    public AccessTransformers getAccessTransformers() {
        return this.accessTransformers;
    }
}

