/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import java.util.Optional;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.dependency.DependencyFilter;
import net.neoforged.gradle.dsl.common.dependency.DependencyVersionInformationHandler;
import net.neoforged.gradle.dsl.common.extensions.JarJar;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.publish.maven.MavenPublication;

public class JarJarExtension
implements JarJar {
    private final Attribute<String> fixedJarJarVersionAttribute = Attribute.of((String)"fixedJarJarVersion", String.class);
    private final Attribute<String> jarJarRangeAttribute = Attribute.of((String)"jarJarRange", String.class);
    private final Project project;
    private boolean disabled;
    private boolean disableDefaultSources;

    @Inject
    public JarJarExtension(Project project) {
        this.project = project;
    }

    public void enable() {
        if (!this.disabled) {
            this.enable(true);
        }
    }

    private void enable(boolean enabled) {
        Task task = this.project.getTasks().findByPath("jarJar");
        if (task != null) {
            task.setEnabled(enabled);
        }
    }

    public void disable() {
        this.disable(true);
    }

    public void disable(boolean disable) {
        this.disabled = disable;
        if (disable) {
            this.enable(false);
        }
    }

    public boolean getDefaultSourcesDisabled() {
        return this.disableDefaultSources;
    }

    public void disableDefaultSources() {
        this.disableDefaultSources(true);
    }

    public void disableDefaultSources(boolean value) {
        this.disableDefaultSources = value;
    }

    public void fromRuntimeConfiguration() {
        this.enable();
        this.project.getTasks().withType(net.neoforged.gradle.common.tasks.JarJar.class).configureEach(net.neoforged.gradle.common.tasks.JarJar::fromRuntimeConfiguration);
    }

    public void pin(Dependency dependency, String version) {
        this.enable();
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            moduleDependency.attributes(attributeContainer -> attributeContainer.attribute(this.fixedJarJarVersionAttribute, (Object)version));
        }
    }

    public Optional<String> getPin(Dependency dependency) {
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            return Optional.ofNullable(moduleDependency.getAttributes().getAttribute(this.fixedJarJarVersionAttribute));
        }
        return Optional.empty();
    }

    public void ranged(Dependency dependency, String range) {
        this.enable();
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            moduleDependency.attributes(attributeContainer -> attributeContainer.attribute(this.jarJarRangeAttribute, (Object)range));
        }
    }

    public Optional<String> getRange(Dependency dependency) {
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            return Optional.ofNullable(moduleDependency.getAttributes().getAttribute(this.jarJarRangeAttribute));
        }
        return Optional.empty();
    }

    public JarJarExtension dependencies(Action<DependencyFilter> c) {
        this.enable();
        this.project.getTasks().withType(net.neoforged.gradle.common.tasks.JarJar.class).configureEach(jarJar -> jarJar.dependencies(c));
        return this;
    }

    public JarJarExtension versionInformation(Action<DependencyVersionInformationHandler> c) {
        this.enable();
        this.project.getTasks().withType(net.neoforged.gradle.common.tasks.JarJar.class).configureEach(jarJar -> jarJar.versionInformation(c));
        return this;
    }

    public MavenPublication component(MavenPublication mavenPublication) {
        return this.component(mavenPublication, true);
    }

    public MavenPublication component(MavenPublication mavenPublication, boolean handleDependencies) {
        this.enable();
        this.project.getTasks().withType(net.neoforged.gradle.common.tasks.JarJar.class).configureEach(task -> this.component(mavenPublication, (net.neoforged.gradle.common.tasks.JarJar)((Object)task), false, handleDependencies));
        return mavenPublication;
    }

    public MavenPublication component(MavenPublication mavenPublication, net.neoforged.gradle.common.tasks.JarJar task) {
        this.enable();
        return this.component(mavenPublication, task, true, true);
    }

    public MavenPublication cleanedComponent(MavenPublication mavenPublication, net.neoforged.gradle.common.tasks.JarJar task, boolean handleDependencies) {
        this.enable();
        return this.component(mavenPublication, task, true, handleDependencies);
    }

    private MavenPublication component(MavenPublication mavenPublication, net.neoforged.gradle.common.tasks.JarJar task, boolean handleCleaning) {
        return this.component(mavenPublication, task, handleCleaning, true);
    }

    private MavenPublication component(MavenPublication mavenPublication, net.neoforged.gradle.common.tasks.JarJar task, boolean handleCleaning, boolean handleDependencies) {
        if (!task.isEnabled()) {
            return mavenPublication;
        }
        if (handleCleaning) {
            // empty if block
        }
        mavenPublication.artifact((Object)task, mavenArtifact -> {
            mavenArtifact.setClassifier((String)task.getArchiveClassifier().get());
            mavenArtifact.setExtension((String)task.getArchiveExtension().get());
        });
        if (handleDependencies) {
            // empty if block
        }
        return mavenPublication;
    }
}

