/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import groovy.lang.Closure;
import java.util.regex.Pattern;
import net.neoforged.gradle.dsl.common.dependency.DependencyManagementObject;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public class AbstractDependencyManagementObject
implements DependencyManagementObject {
    protected final Project project;

    public AbstractDependencyManagementObject(Project project) {
        this.project = project;
    }

    protected static DependencyManagementObject.ArtifactIdentifier createArtifactIdentifier(ResolvedDependency dependency) {
        return new DependencyManagementObject.ArtifactIdentifier(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion());
    }

    protected static DependencyManagementObject.ArtifactIdentifier createArtifactIdentifier(ModuleDependency dependency) {
        return new DependencyManagementObject.ArtifactIdentifier(dependency.getGroup(), dependency.getName(), dependency.getVersion());
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(Object notation) {
        return this.dependency(this.project.getDependencies().create(notation));
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(final Dependency dependency) {
        return this.dependency(new Closure<Boolean>(null){

            public Boolean call(Object it) {
                if (it instanceof DependencyManagementObject.ArtifactIdentifier) {
                    DependencyManagementObject.ArtifactIdentifier identifier = (DependencyManagementObject.ArtifactIdentifier)it;
                    return !(dependency.getGroup() != null && !Pattern.matches(dependency.getGroup(), identifier.getGroup()) || dependency.getName() != null && !Pattern.matches(dependency.getName(), identifier.getName()) || dependency.getVersion() != null && !Pattern.matches(dependency.getVersion(), identifier.getVersion()));
                }
                return false;
            }
        });
    }

    public Spec<? super DependencyManagementObject.ArtifactIdentifier> dependency(Closure<Boolean> spec) {
        return Specs.convertClosureToSpec(spec);
    }
}

