/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runtime.tasks.AccessTransformer;
import net.neoforged.gradle.common.runtime.tasks.AccessTransformerFileGenerator;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.ArtifactProvider;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import org.gradle.api.tasks.TaskProvider;

public final class CommonRuntimeTaskUtils {
    private CommonRuntimeTaskUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: CommonRuntimeTaskUtils. This is a utility class");
    }

    public static TaskProvider<? extends AccessTransformer> createAccessTransformer(Definition<?> definition, String namePreFix, File workspaceDirectory, Consumer<TaskProvider<? extends Runtime>> dependentTaskConfigurationHandler, Iterable<File> files, Collection<String> data) {
        ArrayList<TaskProvider> fileProducingTasks = new ArrayList<TaskProvider>();
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        for (File file : files) {
            indexes.compute(file.getName(), (s, index) -> index == null ? 0 : index + 1);
            int index2 = (Integer)indexes.get(file.getName());
            String name = CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)(namePreFix + "AccessTransformerProvider" + file.getName() + (index2 == 0 ? "" : "_" + index2)));
            TaskProvider provider = definition.getSpecification().getProject().getTasks().register(name, ArtifactProvider.class, task -> {
                task.getInput().set(file);
                String outputFileName = file.getName();
                if (index2 > 0) {
                    int extensionDot = outputFileName.lastIndexOf(46);
                    outputFileName = extensionDot == -1 ? outputFileName + "_" + index2 : outputFileName.substring(0, extensionDot) + "_" + index2 + outputFileName.substring(extensionDot);
                }
                task.getOutput().set(new File(workspaceDirectory, "accesstransformers/" + namePreFix + "/" + outputFileName));
            });
            fileProducingTasks.add(provider);
        }
        if (!data.isEmpty()) {
            TaskProvider generator = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)(namePreFix + "AccessTransformerGenerator")), AccessTransformerFileGenerator.class, task -> {
                task.getOutput().set(new File(workspaceDirectory, "accesstransformers/" + namePreFix + "/_script-access-transformer.cfg"));
                task.getAdditionalTransformers().set((Iterable)data);
            });
            dependentTaskConfigurationHandler.accept((TaskProvider<? extends Runtime>)generator);
            fileProducingTasks.add(generator);
        }
        return definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)String.format("apply%sAccessTransformer", StringCapitalizationUtils.capitalize((String)namePreFix))), AccessTransformer.class, task -> {
            for (TaskProvider fileRemapTask : fileProducingTasks) {
                task.getTransformers().from(new Object[]{fileRemapTask.flatMap(OutputSpecification::getOutput)});
                task.dependsOn(new Object[]{fileRemapTask});
            }
        });
    }
}

