/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@CacheableTask
@NonNullApi
public abstract class PotentiallySignJar
extends DefaultTask
implements PatternFilterable,
WithOutput,
WithWorkspace {
    private final PatternSet patternSet = new PatternSet();

    public PotentiallySignJar() {
        this.getOutputFileName().convention(this.getInput().map(RegularFile::getAsFile).map(file -> net.neoforged.gradle.util.FileUtils.postFixClassifier((File)file, (String)"signed")));
        this.getOutput().convention(this.getOutputFileName().flatMap(fileName -> this.getLayout().getBuildDirectory().dir("libs").map(libsDir -> libsDir.file(fileName))));
    }

    @TaskAction
    public void doTask() throws IOException {
        HashMap ignoredStuff = Maps.newHashMap();
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        if (!this.getAlias().isPresent() || !this.getStorePass().isPresent()) {
            FileUtils.copyFile((File)input, (File)output);
            return;
        }
        File toSign = this.ensureFileWorkspaceReady(new File(this.getTemporaryDir(), input.getName() + ".unsigned.tmp"));
        File signed = this.ensureFileWorkspaceReady(new File(this.getTemporaryDir(), input.getName() + ".signed.tmp"));
        this.processInputJar(input, toSign);
        HashMap map = Maps.newHashMap();
        map.put("alias", this.getAlias().get());
        map.put("storePass", this.getStorePass().get());
        map.put("jar", toSign.getAbsolutePath());
        map.put("signedJar", signed.getAbsolutePath());
        if (this.getKeyPass().isPresent()) {
            map.put("keypass", this.getKeyPass().get());
        }
        if (this.getKeyStore().isPresent()) {
            map.put("keyStore", this.getKeyStore().get());
        }
        this.getAnt().invokeMethod("signjar", (Object)map);
        this.writeOutputJar(signed, input, output);
    }

    private void processInputJar(File inputJar, File toSign) throws IOException {
        FileTree inputFileTree = this.getArchiveOperations().zipTree((Object)inputJar);
        try (FileOutputStream toSignOutputStream = new FileOutputStream(toSign);
             ZipOutputStream toSignZipOutputStream = new ZipOutputStream(toSignOutputStream);){
            ZipBuildingFileTreeVisitor toSignBuilder = new ZipBuildingFileTreeVisitor(toSignZipOutputStream);
            inputFileTree.matching((PatternFilterable)this).visit((FileVisitor)toSignBuilder);
        }
    }

    private void writeOutputJar(File signedJar, File inputJar, File outputJar) throws IOException {
        FileTree inputFileTree = this.getArchiveOperations().zipTree((Object)inputJar);
        FileTree signedFileTree = this.getArchiveOperations().zipTree((Object)signedJar);
        try (FileOutputStream outputStream = new FileOutputStream(outputJar);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            ZipBuildingFileTreeVisitor builder = new ZipBuildingFileTreeVisitor(zipOutputStream);
            signedFileTree.visit((FileVisitor)builder);
            inputFileTree.minus((FileCollection)inputFileTree.matching((PatternFilterable)this)).getAsFileTree().visit((FileVisitor)builder);
        }
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @Input
    @Optional
    public abstract Property<String> getAlias();

    @Input
    @Optional
    public abstract Property<String> getStorePass();

    @Input
    @Optional
    public abstract Property<String> getKeyPass();

    @Input
    @Optional
    public abstract Property<String> getKeyStore();

    public PatternFilterable exclude(String ... arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Iterable<String> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Spec<FileTreeElement> arg0) {
        return this.patternSet.exclude(arg0);
    }

    public PatternFilterable exclude(Closure arg0) {
        return this.patternSet.exclude(arg0);
    }

    @Internal
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Internal
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public PatternFilterable include(String ... arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Iterable<String> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Spec<FileTreeElement> arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable include(Closure arg0) {
        return this.patternSet.include(arg0);
    }

    public PatternFilterable setExcludes(Iterable<String> arg0) {
        return this.patternSet.setExcludes(arg0);
    }

    public PatternFilterable setIncludes(Iterable<String> arg0) {
        return this.patternSet.setIncludes(arg0);
    }
}

