/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFiles;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeMultiArguments;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class RuntimeMultiArgumentsImpl
implements RuntimeMultiArguments {
    private final ProviderFactory providerFactory;

    @Inject
    public RuntimeMultiArgumentsImpl(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public Provider<List<String>> get(String key) {
        return this.getSimple().zip((Provider)this.getFiles(), (simple, files) -> {
            List result = simple.getOrDefault(key, new ArrayList());
            Optional<NamedFiles> file = files.stream().filter(namedFile -> namedFile.getName().equals(key)).reduce((a, b) -> b);
            file.ifPresent(f -> result.addAll(f.getFiles().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList())));
            return result;
        });
    }

    public Provider<List<String>> getOrDefault(String key, Provider<List<String>> defaultProvider) {
        return this.get(key).orElse(defaultProvider);
    }

    public Provider<Map<String, Provider<List<String>>>> AsMap() {
        Provider simpleProvider = this.getSimple().map(Map::keySet).map(keySet -> keySet.stream().collect(Collectors.toMap(key -> key, key -> this.getSimple().getting(key))));
        Provider filesProvider = this.getFiles().map(files -> files.stream().collect(Collectors.toMap(NamedFiles::getName, namedFiles -> this.providerFactory.provider(() -> namedFiles.getFiles().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList())), (a, b) -> b, HashMap::new)));
        return simpleProvider.zip(filesProvider, (simple, files) -> ImmutableMap.builder().putAll(simple).putAll(files).build());
    }

    public void putFiles(String key, ConfigurableFileCollection provider) {
        this.getFiles().add((Object)new NamedFiles(key, provider));
    }

    public void putSimple(String patches, Provider<List<String>> provider) {
        this.getSimple().put((Object)patches, provider);
    }
}

