/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class GenerateExtraJar
extends NeoGradleBase
implements WithOutput,
WithWorkspace {
    public GenerateExtraJar() {
        this.getOutputFileName().set((Object)"client-extra.jar");
    }

    @TaskAction
    public void doTask() throws Throwable {
        File originalJar = ((RegularFile)this.getOriginalJar().get()).getAsFile();
        File outputJar = this.ensureFileWorkspaceReady(this.getOutput());
        FileTree inputTree = this.getArchiveOperations().zipTree((Object)originalJar);
        FileTree filteredInput = inputTree.matching(filter -> filter.exclude(new String[]{"**/*.class"}));
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputJar));){
            filteredInput.visit((FileVisitor)new ZipBuildingFileTreeVisitor(zos));
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getOriginalJar();
}

