/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming.renamer;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.srgutils.IMappingFile;
import net.neoforged.gradle.common.runtime.naming.renamer.RegexBasedSourceRenamer;
import org.gradle.api.tasks.Nested;

public class IMappingFileSourceRenamer
extends RegexBasedSourceRenamer {
    private final Map<String, String> names;
    private final Map<String, String> docs;

    private IMappingFileSourceRenamer(Map<String, String> names, Map<String, String> docs) {
        this.names = names;
        this.docs = docs;
    }

    public static IMappingFileSourceRenamer from(File clientFile, File serverFile) throws IOException {
        IMappingFile pg_client = IMappingFile.load((File)clientFile);
        IMappingFile pg_server = IMappingFile.load((File)serverFile);
        return IMappingFileSourceRenamer.from(pg_client, pg_server);
    }

    public static IMappingFileSourceRenamer from(IMappingFile pg_client, IMappingFile pg_server) throws IOException {
        ConcurrentHashMap<String, String> names = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap cfields = new ConcurrentHashMap();
        ConcurrentHashMap sfields = new ConcurrentHashMap();
        ConcurrentHashMap cmethods = new ConcurrentHashMap();
        ConcurrentHashMap smethods = new ConcurrentHashMap();
        pg_client.getClasses().parallelStream().forEach(cls -> IMappingFileSourceRenamer.processClass(cfields, cmethods, cls));
        pg_server.getClasses().parallelStream().forEach(cls -> IMappingFileSourceRenamer.processClass(sfields, smethods, cls));
        cfields.keySet().parallelStream().forEach(name -> IMappingFileSourceRenamer.processName(names, cfields, sfields, name));
        cmethods.keySet().parallelStream().forEach(name -> IMappingFileSourceRenamer.processName(names, cmethods, smethods, name));
        return new IMappingFileSourceRenamer(names, Collections.emptyMap());
    }

    private static void processName(Map<String, String> names, Map<String, String> clientData, Map<String, String> serverData, String name) {
        String cname = clientData.get(name);
        String sname = serverData.get(name);
        names.put(name, cname);
        if (cname.equals(sname)) {
            serverData.remove(name);
        }
    }

    private static void processClass(Map<String, String> fields, Map<String, String> methods, IMappingFile.IClass classData) {
        for (IMappingFile.IField fld : classData.getFields()) {
            fields.put(fld.getMapped(), fld.getOriginal());
        }
        for (IMappingFile.IMethod mtd : classData.getMethods()) {
            methods.put(mtd.getMapped(), mtd.getOriginal());
        }
    }

    @Override
    @Nested
    public Map<String, String> getNames() {
        return this.names;
    }

    @Override
    @Nested
    public Map<String, String> getDocs() {
        return this.docs;
    }
}

