/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.definition;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.ArtifactProvider;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonRuntimeDefinition<S extends CommonRuntimeSpecification>
implements Definition<S> {
    @NotNull
    private final S specification;
    @NotNull
    private final LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs;
    @NotNull
    private final TaskProvider<? extends ArtifactProvider> sourceJarTask;
    @NotNull
    private final TaskProvider<? extends ArtifactProvider> rawJarTask;
    @NotNull
    private final Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactProvidingTasks;
    @NotNull
    private final Configuration minecraftDependenciesConfiguration;
    @NotNull
    private final Map<String, String> mappingVersionData = Maps.newHashMap();
    @NotNull
    private final Consumer<TaskProvider<? extends Runtime>> associatedTaskConsumer;
    @NotNull
    private final VersionJson versionJson;
    @Nullable
    private Dependency replacedDependency = null;

    protected CommonRuntimeDefinition(@NotNull S specification, @NotNull LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs, @NotNull TaskProvider<? extends ArtifactProvider> sourceJarTask, @NotNull TaskProvider<? extends ArtifactProvider> rawJarTask, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactProvidingTasks, @NotNull Configuration minecraftDependenciesConfiguration, @NotNull Consumer<TaskProvider<? extends Runtime>> associatedTaskConsumer, @NotNull VersionJson versionJson) {
        this.specification = specification;
        this.taskOutputs = taskOutputs;
        this.sourceJarTask = sourceJarTask;
        this.rawJarTask = rawJarTask;
        this.gameArtifactProvidingTasks = gameArtifactProvidingTasks;
        this.minecraftDependenciesConfiguration = minecraftDependenciesConfiguration;
        this.associatedTaskConsumer = associatedTaskConsumer;
        this.versionJson = versionJson;
    }

    @NotNull
    public final TaskProvider<? extends WithOutput> getTask(String name) {
        String taskName = CommonRuntimeUtils.buildTaskName((Definition)this, (String)name);
        if (!this.taskOutputs.containsKey(taskName)) {
            throw new IllegalArgumentException("No task with name " + name + " found in runtime " + ((CommonRuntimeSpecification)this.specification).getVersionedName());
        }
        return this.taskOutputs.get(taskName);
    }

    @NotNull
    public final TaskProvider<? extends ArtifactProvider> getRawJarTask() {
        return this.rawJarTask;
    }

    @NotNull
    public final S getSpecification() {
        return this.specification;
    }

    @NotNull
    public final LinkedHashMap<String, TaskProvider<? extends WithOutput>> getTasks() {
        return this.taskOutputs;
    }

    @NotNull
    public final TaskProvider<? extends ArtifactProvider> getSourceJarTask() {
        return this.sourceJarTask;
    }

    @NotNull
    public final Map<GameArtifact, TaskProvider<? extends WithOutput>> getGameArtifactProvidingTasks() {
        return this.gameArtifactProvidingTasks;
    }

    @NotNull
    public final Configuration getMinecraftDependenciesConfiguration() {
        return this.minecraftDependenciesConfiguration;
    }

    @NotNull
    public final Dependency getReplacedDependency() {
        if (this.replacedDependency == null) {
            throw new IllegalStateException("No dependency has been replaced yet.");
        }
        return this.replacedDependency;
    }

    public void setReplacedDependency(@NotNull Dependency dependency) {
        this.replacedDependency = dependency;
    }

    public void onRepoWritten(@NotNull TaskProvider<? extends WithOutput> finalRepoWritingTask) {
    }

    @NotNull
    public Map<String, String> getMappingVersionData() {
        return this.mappingVersionData;
    }

    public final void setMappingVersionData(@NotNull Map<String, String> data) {
        this.mappingVersionData.clear();
        this.mappingVersionData.putAll(data);
    }

    public void configureAssociatedTask(@NotNull TaskProvider<? extends Runtime> runtimeTask) {
        this.associatedTaskConsumer.accept(runtimeTask);
    }

    @NotNull
    public abstract TaskProvider<DownloadAssets> getAssets();

    @NotNull
    public abstract TaskProvider<ExtractNatives> getNatives();

    @NotNull
    public VersionJson getVersionJson() {
        return this.versionJson;
    }

    public void configureRun(RunImpl run) {
        Map<String, String> runtimeInterpolationData = this.buildRunInterpolationData();
        HashMap<String, String> workingInterpolationData = new HashMap<String, String>(runtimeInterpolationData);
        workingInterpolationData.put("source_roots", (String)RunsUtil.buildGradleModClasses((ListProperty<SourceSet>)run.getModSources()).get());
        if (((Boolean)run.getIsClient().get()).booleanValue()) {
            this.getVersionJson().getPlatformJvmArgs().forEach(arg -> run.getJvmArguments().add(arg));
        }
        run.overrideJvmArguments(this.interpolate(run.getJvmArguments(), workingInterpolationData));
        run.overrideProgramArguments(this.interpolate(run.getProgramArguments(), workingInterpolationData));
        run.overrideEnvironmentVariables(this.interpolate(run.getEnvironmentVariables(), workingInterpolationData));
        run.overrideSystemProperties(this.interpolate(run.getSystemProperties(), workingInterpolationData));
        if (((Boolean)run.getIsClient().get()).booleanValue() || ((Boolean)run.getIsDataGenerator().get()).booleanValue()) {
            run.dependsOn(this.getAssets(), this.getNatives());
        }
    }

    protected Map<String, String> buildRunInterpolationData() {
        HashMap interpolationData = Maps.newHashMap();
        interpolationData.put("runtime_name", ((CommonRuntimeSpecification)this.specification).getVersionedName());
        interpolationData.put("mc_version", this.specification.getMinecraftVersion());
        interpolationData.put("assets_root", ((Directory)((DownloadAssets)((Object)this.getAssets().get())).getOutputDirectory().get()).getAsFile().getAbsolutePath());
        interpolationData.put("asset_index", ((RegularFile)((DownloadAssets)((Object)this.getAssets().get())).getAssetIndexFile().get()).getAsFile().getName().substring(0, ((RegularFile)((DownloadAssets)((Object)this.getAssets().get())).getAssetIndexFile().get()).getAsFile().getName().lastIndexOf(46)));
        interpolationData.put("natives", ((Directory)((ExtractNatives)((Object)this.getNatives().get())).getOutputDirectory().get()).getAsFile().getAbsolutePath());
        return interpolationData;
    }

    public void onBake(NamingChannel namingChannel, File runtimeDirectory) {
    }

    protected ListProperty<String> interpolate(ListProperty<String> input, Map<String, String> values) {
        return this.interpolate(input, values, "");
    }

    protected ListProperty<String> interpolate(ListProperty<String> input, Map<String, String> values, String patternPrefix) {
        ListProperty delegated = this.getSpecification().getProject().getObjects().listProperty(String.class);
        delegated.set(input.map(list -> list.stream().map(s -> CommonRuntimeDefinition.interpolate(s, values, patternPrefix)).collect(Collectors.toList())));
        return delegated;
    }

    protected MapProperty<String, String> interpolate(MapProperty<String, String> input, Map<String, String> values) {
        return this.interpolate(input, values, "");
    }

    protected MapProperty<String, String> interpolate(MapProperty<String, String> input, Map<String, String> values, String patternPrefix) {
        MapProperty delegated = this.getSpecification().getProject().getObjects().mapProperty(String.class, String.class);
        delegated.set(input.map(list -> list.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CommonRuntimeDefinition.interpolate((String)e.getValue(), values, patternPrefix)))));
        return delegated;
    }

    private static String interpolate(String input, Map<String, String> values, String patternPrefix) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        String result = input;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            result = result.replace(patternPrefix + "{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }
}

