/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.repository.IvyDummyRepositoryEntry;
import net.neoforged.gradle.common.extensions.repository.IvyDummyRepositoryMetadataSupplier;
import net.neoforged.gradle.common.extensions.repository.IvyModuleWriter;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryEntry;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryReference;
import net.neoforged.gradle.dsl.common.util.ModuleReference;
import net.neoforged.gradle.util.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public abstract class IvyDummyRepositoryExtension
implements ConfigurableDSLElement<IvyDummyRepositoryExtension>,
Repository<IvyDummyRepositoryExtension> {
    public static int METADATA_VERSION = 2;
    public static final String IVY_METADATA_PATTERN = "[organisation]/[module]/[revision]/ivy-[revision]-fg" + METADATA_VERSION + ".xml";
    private final Set<IvyDummyRepositoryEntry> entries = Sets.newHashSet();
    private final LinkedHashSet<Consumer<Project>> entryConfigurators = new LinkedHashSet();
    private final Set<Consumer<Project>> afterEntryCallbacks = Sets.newHashSet();
    private final Set<ModuleReference> configuredReferences = Sets.newHashSet();
    private boolean hasBeenRealized = false;
    private final Project project;

    @Inject
    public IvyDummyRepositoryExtension(Project project) {
        this.project = project;
        this.getRepositoryDirectory().convention(project.getLayout().getProjectDirectory().dir(".gradle/repositories"));
        this.createRepositories();
    }

    public Project getProject() {
        return this.project;
    }

    public void onPostDefinitionBake(Project project) {
        this.hasBeenRealized = true;
        this.entryConfigurators.forEach(e -> e.accept(project));
        if (project.getState().getFailure() == null) {
            this.afterEntryCallbacks.forEach(e -> e.accept(project));
        }
    }

    private void createRepositories() {
        this.project.getRepositories().ivy(this.repositoryConfiguration("NeoGradle Artifacts", (Provider<Directory>)this.getRepositoryDirectory()));
    }

    @NotNull
    public abstract DirectoryProperty getRepositoryDirectory();

    private Action<IvyArtifactRepository> repositoryConfiguration(String name, Provider<Directory> root) {
        return ivy -> {
            ivy.setName(name);
            ivy.setUrl(((Directory)root.get()).getAsFile().toURI());
            ivy.patternLayout(layout -> {
                layout.artifact("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])");
                layout.ivy(IVY_METADATA_PATTERN);
                layout.setM2compatible(true);
            });
            ivy.setMetadataSupplier(IvyDummyRepositoryMetadataSupplier.class, params -> params.params(new Object[]{this.project.provider(this::getEntries), root}));
            ivy.setAllowInsecureProtocol(true);
            ivy.getResolve().setDynamicMode(false);
            ivy.metadataSources(IvyArtifactRepository.MetadataSources::ivyDescriptor);
        };
    }

    public void withDependency(Action<RepositoryReference.Builder<?, ?>> referenceBuilder, Action<RepositoryReference> onReferenceBuild, Action<RepositoryEntry.Builder<?, ?, ?>> configurator, Action<RepositoryEntry<?, ?>> configuredEntryConsumer, boolean processImmediately) throws XMLStreamException, IOException {
        IvyDummyRepositoryEntry.Builder builder = (IvyDummyRepositoryEntry.Builder)this.project.getObjects().newInstance(IvyDummyRepositoryEntry.Builder.class, new Object[]{this.project});
        referenceBuilder.execute((Object)builder);
        IvyDummyRepositoryEntry entry = builder.build();
        onReferenceBuild.execute((Object)entry);
        if (!processImmediately) {
            this.entryConfigurators.add(evaluatedProject -> this.processDependency(configurator, configuredEntryConsumer));
        } else {
            this.processDependency(configurator, configuredEntryConsumer);
        }
    }

    public boolean isDynamicDependency(ModuleDependency dependency) {
        return dependency.getGroup() != null && dependency.getGroup().startsWith("ng_dummy_ng");
    }

    private void processDependency(Action<RepositoryEntry.Builder<?, ?, ?>> configurator, Action<RepositoryEntry<?, ?>> configuredEntryConsumer) {
        IvyDummyRepositoryEntry.Builder builder = IvyDummyRepositoryEntry.Builder.create(this.getProject());
        configurator.execute((Object)builder);
        IvyDummyRepositoryEntry entry = builder.build();
        this.processBuildEntry(configuredEntryConsumer, entry);
    }

    private void processBuildEntry(Action<RepositoryEntry<?, ?>> configuredEntryConsumer, IvyDummyRepositoryEntry entry) {
        ModuleReference reference = entry.toModuleReference();
        if (this.configuredReferences.contains(reference)) {
            return;
        }
        this.configuredReferences.add(reference);
        this.registerEntry(entry);
        try {
            this.writeDummyDataIfNeeded(entry);
            configuredEntryConsumer.execute((Object)entry);
        }
        catch (IOException | XMLStreamException e2) {
            throw new RuntimeException("Failed to write dummy data for dependency: " + entry, e2);
        }
        entry.getDependencies().stream().filter(IvyDummyRepositoryEntry.class::isInstance).map(IvyDummyRepositoryEntry.class::cast).filter(e -> !e.toModuleReference().equals((Object)entry.toModuleReference())).forEach(e -> this.processBuildEntry(configuredEntryConsumer, (IvyDummyRepositoryEntry)e));
    }

    private void registerEntry(IvyDummyRepositoryEntry entry) {
        this.entries.add(entry);
    }

    private void writeDummyDataIfNeeded(RepositoryEntry<?, ?> entry) throws IOException, XMLStreamException {
        Path jarFile = entry.buildArtifactPath(((Directory)this.getRepositoryDirectory().get()).getAsFile().toPath());
        Path baseDir = jarFile.getParent();
        Path metaFile = baseDir.resolve(String.format("ivy-%s-fg%d.xml", entry.getVersion(), METADATA_VERSION));
        if (Files.exists(metaFile, new LinkOption[0])) {
            FileUtils.delete((Path)metaFile);
            IvyDummyRepositoryExtension.writeIvyMetadataFile(entry, jarFile, baseDir, metaFile);
            return;
        }
        IvyDummyRepositoryExtension.writeIvyMetadataFile(entry, jarFile, baseDir, metaFile);
        Files.createFile(jarFile, new FileAttribute[0]);
        Path sourcesFile = entry.asSources().buildArtifactPath(((Directory)this.getRepositoryDirectory().get()).getAsFile().toPath());
        Files.createFile(sourcesFile, new FileAttribute[0]);
        this.writeDummyDependencyDataIfNeeded(entry);
    }

    private static void writeIvyMetadataFile(RepositoryEntry<?, ?> entry, Path jarFile, Path baseDir, Path metaFile) throws IOException, XMLStreamException {
        Files.createDirectories(baseDir, new FileAttribute[0]);
        Path metaFileTmp = FileUtils.temporaryPath((Path)metaFile.getParent(), (String)"metadata");
        try (IvyModuleWriter writer = new IvyModuleWriter(metaFileTmp);){
            writer.write(entry);
        }
        FileUtils.atomicMove((Path)metaFileTmp, (Path)metaFile);
    }

    private void writeDummyDependencyDataIfNeeded(RepositoryEntry<?, ?> entry) throws IOException, XMLStreamException {
        for (RepositoryReference o : entry.getDependencies()) {
            if (!(o instanceof RepositoryEntry)) continue;
            RepositoryEntry repositoryEntry = (RepositoryEntry)o;
            this.writeDummyDataIfNeeded(repositoryEntry);
        }
    }

    public Set<IvyDummyRepositoryEntry> getEntries() {
        return this.entries;
    }

    public void afterEntryRealisation(Consumer<Project> projectConsumer) {
        if (this.hasBeenRealized) {
            projectConsumer.accept(this.getProject());
        } else {
            this.afterEntryCallbacks.add(projectConsumer);
        }
    }
}

