/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.dependency.replacement;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.dependency.creation.DependencyCreator;
import net.neoforged.gradle.common.extensions.dependency.replacement.DependencyReplacementContext;
import net.neoforged.gradle.common.extensions.dependency.replacement.DependencyReplacementHandlerImpl;
import net.neoforged.gradle.common.tasks.ArtifactFromOutput;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.Context;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementHandler;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementResult;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryEntry;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryReference;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ModuleReference;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class DependencyReplacementsExtension
implements ConfigurableDSLElement<DependencyReplacement>,
DependencyReplacement {
    private final Project project;
    private final DependencyCreator dependencyCreator;
    private final Set<ModuleReference> configuredReferences = Sets.newHashSet();
    private final Set<ModuleReference> configuredGradleTasks = Sets.newHashSet();
    private final Set<ModuleReference> configuredIdeTasks = Sets.newHashSet();
    private final Table<Dependency, Configuration, Optional<DependencyReplacementResult>> dependencyReplacementInformation = HashBasedTable.create();
    private final NamedDomainObjectContainer<DependencyReplacementHandler> dependencyReplacementHandlers;
    private boolean hasBeenBaked = false;
    private final Set<Consumer<Project>> afterDefinitionBakeCallbacks = Sets.newHashSet();

    @Inject
    public DependencyReplacementsExtension(Project project, DependencyCreator dependencyCreator) {
        this.project = project;
        this.dependencyCreator = dependencyCreator;
        this.project.getConfigurations().configureEach(this::handleConfiguration);
        this.dependencyReplacementHandlers = this.project.getObjects().domainObjectContainer(DependencyReplacementHandler.class, name -> (DependencyReplacementHandlerImpl)this.project.getObjects().newInstance(DependencyReplacementHandlerImpl.class, new Object[]{this.project, name}));
    }

    public void handleConfiguration(Configuration configuration) {
        configuration.getDependencies().whenObjectAdded(dependency -> {
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                this.handleDependency(configuration, moduleDependency);
            }
        });
    }

    public Project getProject() {
        return this.project;
    }

    @VisibleForTesting
    boolean hasBeenBaked() {
        return this.hasBeenBaked;
    }

    public void onPostDefinitionBakes(Project project) {
        this.hasBeenBaked = true;
        if (project.getState().getFailure() == null) {
            this.afterDefinitionBakeCallbacks.forEach(e -> e.accept(project));
        }
    }

    @NotNull
    public NamedDomainObjectContainer<DependencyReplacementHandler> getReplacementHandlers() {
        return this.dependencyReplacementHandlers;
    }

    @VisibleForTesting
    void handleDependency(Configuration configuration, ModuleDependency dependency) {
        Optional candidate;
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        if (repository.isDynamicDependency(dependency)) {
            candidate = Optional.empty();
            this.dependencyReplacementInformation.put((Object)dependency, (Object)configuration, candidate);
        } else if (this.dependencyReplacementInformation.contains((Object)dependency, (Object)configuration)) {
            candidate = (Optional)this.dependencyReplacementInformation.get((Object)dependency, (Object)configuration);
            if (candidate == null) {
                candidate = Optional.empty();
                this.dependencyReplacementInformation.remove((Object)dependency, (Object)configuration);
            }
        } else {
            candidate = Optional.empty();
            for (DependencyReplacementHandler handler : this.getReplacementHandlers()) {
                try {
                    Optional dependencyReplacementResult = ((net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacer)handler.getReplacer().get()).get((Context)new DependencyReplacementContext(this.project, configuration, dependency, null));
                    if (!dependencyReplacementResult.isPresent()) continue;
                    candidate = dependencyReplacementResult;
                    break;
                }
                catch (Exception exception) {
                    throw new GradleException("Uncaught exception while processing replacement of dependency " + dependency.getGroup() + ":" + dependency.getName() + " using handler " + handler + ": " + exception.getMessage(), (Throwable)exception);
                }
            }
            if (!this.dependencyReplacementInformation.contains((Object)dependency, (Object)configuration)) {
                this.dependencyReplacementInformation.put((Object)dependency, (Object)configuration, candidate);
            }
        }
        candidate.ifPresent(result -> this.handleDependencyReplacement(configuration, (Dependency)dependency, (DependencyReplacementResult)result, this::handleDependencyReplacementForIde, this::handleDependencyReplacementForGradle));
    }

    @VisibleForTesting
    @NotNull
    Set<Consumer<Project>> getAfterDefinitionBakeCallbacks() {
        return this.afterDefinitionBakeCallbacks;
    }

    @VisibleForTesting
    void handleDependencyReplacement(Configuration configuration, Dependency dependency, DependencyReplacementResult result, DependencyReplacer ideReplacer, DependencyReplacer gradleReplacer) {
        configuration.getDependencies().remove((Object)dependency);
        List targetConfigurations = result.getTargetConfiguration().orElseGet(() -> {
            ArrayList<Configuration> list = new ArrayList<Configuration>();
            list.add(configuration);
            return list;
        });
        IdeManagementExtension ideManagementExtension = (IdeManagementExtension)this.getProject().getExtensions().getByType(IdeManagementExtension.class);
        if (ideManagementExtension.isIdeImportInProgress()) {
            ideReplacer.handle(targetConfigurations, configuration, dependency, result);
        }
        gradleReplacer.handle(targetConfigurations, configuration, dependency, result);
    }

    private void handleDependencyReplacementForGradle(List<Configuration> configurations, Configuration originalConfiguration, Dependency dependency, DependencyReplacementResult result) {
        this.createDependencyReplacementResult(configurations, originalConfiguration, dependency, result, (repoBaseDir, entry) -> {
            ModuleReference reference = entry.toModuleReference();
            String artifactSelectionTaskName = (String)result.getTaskNameBuilder().apply(CommonRuntimeUtils.buildTaskName((String)"selectRawArtifact", (ModuleReference)reference));
            if (this.configuredGradleTasks.contains(reference)) {
                return new RepositoryEntryGenerationTasks((TaskProvider<? extends WithOutput>)this.project.getTasks().named(artifactSelectionTaskName, ArtifactFromOutput.class));
            }
            this.configuredGradleTasks.add(reference);
            return new RepositoryEntryGenerationTasks((TaskProvider<? extends WithOutput>)this.project.getTasks().register(artifactSelectionTaskName, ArtifactFromOutput.class, artifactFromOutput -> {
                artifactFromOutput.setGroup("neogradle/dependencies");
                artifactFromOutput.setDescription(String.format("Selects the raw artifact from the %s dependency and puts it in the Ivy repository", dependency));
                artifactFromOutput.getInput().set(result.getRawJarTaskProvider().flatMap(OutputSpecification::getOutput));
                artifactFromOutput.getOutput().fileProvider(repoBaseDir.map(TransformerUtils.guard(dir -> entry.buildArtifactPath(dir.getAsFile().toPath()).toFile())));
                artifactFromOutput.dependsOn(new Object[]{result.getRawJarTaskProvider()});
            }));
        });
    }

    private void handleDependencyReplacementForIde(List<Configuration> configurations, Configuration originalConfiguration, Dependency dependency, DependencyReplacementResult result) {
        this.createDependencyReplacementResult(configurations, originalConfiguration, dependency, result, (repoBaseDir, entry) -> {
            ModuleReference reference = entry.toModuleReference();
            String rawArtifactSelectorName = (String)result.getTaskNameBuilder().apply(CommonRuntimeUtils.buildTaskName((String)"selectRawArtifact", (ModuleReference)reference));
            String sourceArtifactSelectorName = (String)result.getTaskNameBuilder().apply(CommonRuntimeUtils.buildTaskName((String)"selectSourceArtifact", (ModuleReference)reference));
            if (this.configuredIdeTasks.contains(reference)) {
                TaskProvider rawProvider = this.project.getTasks().named(rawArtifactSelectorName, WithOutput.class);
                TaskProvider sourceProvider = this.project.getTasks().named(sourceArtifactSelectorName, WithOutput.class);
                return new RepositoryEntryGenerationTasks((TaskProvider<? extends WithOutput>)rawProvider, (TaskProvider<? extends WithOutput>)sourceProvider);
            }
            this.configuredIdeTasks.add(reference);
            TaskProvider rawProvider = this.project.getTasks().register(rawArtifactSelectorName, ArtifactFromOutput.class, artifactFromOutput -> {
                artifactFromOutput.setGroup("neogradle/dependencies");
                artifactFromOutput.setDescription(String.format("Selects the raw artifact from the %s dependency and puts it in the Ivy repository", dependency));
                artifactFromOutput.getInput().set(result.getRawJarTaskProvider().flatMap(OutputSpecification::getOutput));
                artifactFromOutput.getOutput().fileProvider(repoBaseDir.map(TransformerUtils.guard(dir -> entry.buildArtifactPath(dir.getAsFile().toPath()).toFile())));
                artifactFromOutput.dependsOn(new Object[]{result.getRawJarTaskProvider()});
            });
            TaskProvider sourceProvider = this.project.getTasks().register(sourceArtifactSelectorName, ArtifactFromOutput.class, artifactFromOutput -> {
                artifactFromOutput.setGroup("neogradle/dependencies");
                artifactFromOutput.setDescription(String.format("Selects the source artifact from the %s dependency and puts it in the Ivy repository", dependency));
                artifactFromOutput.getInput().set(result.getSourcesJarTaskProvider().flatMap(OutputSpecification::getOutput));
                artifactFromOutput.getOutput().fileProvider(repoBaseDir.map(TransformerUtils.guard(dir -> entry.asSources().buildArtifactPath(dir.getAsFile().toPath()).toFile())));
                artifactFromOutput.dependsOn(new Object[]{result.getSourcesJarTaskProvider()});
            });
            return new RepositoryEntryGenerationTasks((TaskProvider<? extends WithOutput>)rawProvider, (TaskProvider<? extends WithOutput>)sourceProvider);
        });
    }

    @VisibleForTesting
    void createDependencyReplacementResult(List<Configuration> configurations, Configuration originalConfiguration, Dependency dependency, DependencyReplacementResult result, TaskProviderGenerator generator) {
        if (!(dependency instanceof ExternalModuleDependency)) {
            return;
        }
        ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependency;
        Repository extension = (Repository)this.project.getExtensions().getByType(Repository.class);
        DirectoryProperty repoBaseDir = extension.getRepositoryDirectory();
        try {
            extension.withDependency(builder -> this.configureRepositoryReference(result, externalModuleDependency, (RepositoryReference.Builder<?, ?>)builder), arg_0 -> this.lambda$createDependencyReplacementResult$14(configurations, result, generator, (Provider)repoBaseDir, arg_0), builder -> this.configureRepositoryEntry(result, externalModuleDependency, (RepositoryEntry.Builder<?, ?, ?>)builder), arg_0 -> this.lambda$createDependencyReplacementResult$16(configurations, originalConfiguration, result, generator, (Provider)repoBaseDir, arg_0), result.getProcessImmediately().booleanValue());
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(String.format("Failed to create the dummy dependency for: %s", dependency), e);
        }
    }

    private void processRepositoryReference(List<Configuration> configurations, DependencyReplacementResult result, TaskProviderGenerator generator, Provider<Directory> repoBaseDir, RepositoryReference entry) {
        Dependency replacedDependency = entry.toGradle(this.project);
        configurations.forEach(configuration -> {
            Configuration container = (Configuration)this.project.getConfigurations().maybeCreate("ng_dummy_ng_" + configuration.getName());
            container.getDependencies().add((Object)replacedDependency);
            configuration.extendsFrom(new Configuration[]{container});
        });
        result.getOnCreateReplacedDependencyCallback().accept(replacedDependency);
    }

    private void processRepositoryEntry(List<Configuration> configurations, Configuration originalConfiguration, DependencyReplacementResult result, TaskProviderGenerator generator, Provider<Directory> repoBaseDir, RepositoryEntry<?, ?> entry) {
        ModuleReference reference = entry.toModuleReference();
        if (this.configuredReferences.contains(reference)) {
            return;
        }
        this.configuredReferences.add(reference);
        RepositoryEntryGenerationTasks entryGenerationTasks = generator.generate(repoBaseDir, entry);
        Dependency replacedDependency = this.dependencyCreator.from(entryGenerationTasks.getRawJarProvider());
        originalConfiguration.getDependencies().add((Object)replacedDependency);
        result.getOnRepoWritingTaskRegisteredCallback().accept(entryGenerationTasks.getRawJarProvider());
        this.afterDefinitionBake(projectAfterBake -> {
            IdeManagementExtension ideManagementExtension = (IdeManagementExtension)this.getProject().getExtensions().getByType(IdeManagementExtension.class);
            if (ideManagementExtension.isIdeImportInProgress()) {
                ideManagementExtension.registerTaskToRun(entryGenerationTasks.getRawJarProvider());
                entryGenerationTasks.getSourceJarProvider().ifPresent(ideManagementExtension::registerTaskToRun);
                result.getAdditionalIdePostSyncTasks().forEach(ideManagementExtension::registerTaskToRun);
            }
        });
    }

    private void configureRepositoryReference(DependencyReplacementResult result, ExternalModuleDependency externalModuleDependency, RepositoryReference.Builder<?, ?> builder) {
        builder.from((ModuleDependency)externalModuleDependency);
        result.getReferenceConfigurator().accept(builder);
    }

    private void configureRepositoryEntry(DependencyReplacementResult result, ExternalModuleDependency externalModuleDependency, RepositoryEntry.Builder<?, ?, ?> builder) {
        builder.from((ModuleDependency)externalModuleDependency);
        result.getMetadataConfigurator().accept(builder);
        result.getAdditionalDependenciesConfiguration().getAllDependencies().stream().filter(ExternalModuleDependency.class::isInstance).map(ExternalModuleDependency.class::cast).forEach(additionalDependency -> builder.withDependency(depBuilder -> depBuilder.from((ModuleDependency)additionalDependency)));
    }

    public void afterDefinitionBake(Consumer<Project> callback) {
        if (this.hasBeenBaked) {
            callback.accept(this.project);
            return;
        }
        this.afterDefinitionBakeCallbacks.add(callback);
    }

    private /* synthetic */ void lambda$createDependencyReplacementResult$16(List configurations, Configuration originalConfiguration, DependencyReplacementResult result, TaskProviderGenerator generator, Provider repoBaseDir, RepositoryEntry entry) {
        this.processRepositoryEntry(configurations, originalConfiguration, result, generator, (Provider<Directory>)repoBaseDir, entry);
    }

    private /* synthetic */ void lambda$createDependencyReplacementResult$14(List configurations, DependencyReplacementResult result, TaskProviderGenerator generator, Provider repoBaseDir, RepositoryReference reference) {
        this.processRepositoryReference(configurations, result, generator, (Provider<Directory>)repoBaseDir, reference);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface DependencyReplacer {
        public void handle(List<Configuration> var1, Configuration var2, Dependency var3, DependencyReplacementResult var4);
    }

    @FunctionalInterface
    @VisibleForTesting
    static interface TaskProviderGenerator {
        public RepositoryEntryGenerationTasks generate(Provider<Directory> var1, RepositoryEntry<?, ?> var2);
    }

    @VisibleForTesting
    public static class RepositoryEntryGenerationTasks {
        @NotNull
        private final TaskProvider<? extends WithOutput> rawJarProvider;
        @Nullable
        private final TaskProvider<? extends WithOutput> sourceJarProvider;

        public RepositoryEntryGenerationTasks(@NotNull TaskProvider<? extends WithOutput> rawJarProvider) {
            this.rawJarProvider = rawJarProvider;
            this.sourceJarProvider = null;
        }

        public RepositoryEntryGenerationTasks(@NotNull TaskProvider<? extends WithOutput> rawJarProvider, @Nullable TaskProvider<? extends WithOutput> sourceJarProvider) {
            this.rawJarProvider = rawJarProvider;
            this.sourceJarProvider = sourceJarProvider;
        }

        public TaskProvider<? extends WithOutput> getRawJarProvider() {
            return this.rawJarProvider;
        }

        public Optional<TaskProvider<? extends WithOutput>> getSourceJarProvider() {
            return Optional.ofNullable(this.sourceJarProvider);
        }
    }
}

