/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import javax.inject.Inject;
import net.neoforged.gradle.common.tasks.IdePostSyncExecutionTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.gradle.ext.IdeaExtPlugin;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.TaskTriggersConfig;

public abstract class IdeManagementExtension {
    private final Project project;
    private final Project rootProject;

    @Inject
    public IdeManagementExtension(Project project) {
        this.project = project;
        this.rootProject = project.getRootProject();
        project.getPlugins().apply(IdeaExtPlugin.class);
        project.getPlugins().apply(EclipsePlugin.class);
        if (project != this.rootProject) {
            if (!this.rootProject.getPlugins().hasPlugin(IdeaExtPlugin.class)) {
                this.rootProject.getPlugins().apply(IdeaExtPlugin.class);
            }
            if (!this.rootProject.getPlugins().hasPlugin(EclipsePlugin.class)) {
                this.rootProject.getPlugins().apply(EclipsePlugin.class);
            }
        }
        if (this.isIdeaImport()) {
            this.getOrCreateIdeImportTask();
        }
    }

    public boolean isIdeaImport() {
        return Boolean.getBoolean("idea.active");
    }

    public boolean isEclipseImport() {
        return System.getProperty("eclipse.application") != null;
    }

    public boolean isIdeImportInProgress() {
        return this.isIdeaImport() || this.isEclipseImport();
    }

    public void registerTaskToRun(TaskProvider<?> taskToRun) {
        TaskProvider<? extends Task> idePostSyncTask = this.getOrCreateIdeImportTask();
        idePostSyncTask.configure(task -> task.dependsOn(new Object[]{taskToRun}));
    }

    @NotNull
    public TaskProvider<? extends Task> getOrCreateIdeImportTask() {
        TaskProvider idePostSyncTask;
        if (!this.project.getTasks().getNames().contains("idePostSync")) {
            idePostSyncTask = this.project.getTasks().register("idePostSync", IdePostSyncExecutionTask.class);
            this.apply(new IdeImportAction(){

                @Override
                public void idea(Project project, IdeaModel idea, ProjectSettings ideaExtension) {
                    TaskTriggersConfig taskTriggers = (TaskTriggersConfig)((ExtensionAware)ideaExtension).getExtensions().getByType(TaskTriggersConfig.class);
                    taskTriggers.afterSync(new Object[]{idePostSyncTask});
                }

                @Override
                public void eclipse(Project project, EclipseModel eclipse) {
                    eclipse.synchronizationTasks(new Object[]{idePostSyncTask});
                }
            });
        } else {
            idePostSyncTask = this.project.getTasks().named("idePostSync");
        }
        return idePostSyncTask;
    }

    public void apply(IdeImportAction toPerform) {
        this.onIdea(toPerform);
        this.onEclipse(toPerform);
        this.onGradle(toPerform);
    }

    public void onIdea(IdeaIdeImportAction toPerform) {
        this.project.getPlugins().withType(IdeaExtPlugin.class, plugin -> {
            if (!this.isIdeaImport()) {
                return;
            }
            IdeaModel model = (IdeaModel)this.project.getExtensions().findByType(IdeaModel.class);
            if (model == null || model.getProject() == null) {
                model = (IdeaModel)this.rootProject.getExtensions().findByType(IdeaModel.class);
            }
            if (model == null || model.getProject() == null) {
                throw new IllegalStateException("IDEA model is null, even though the IDEA plugin is applied.");
            }
            ProjectSettings ideaExt = (ProjectSettings)((ExtensionAware)model.getProject()).getExtensions().getByType(ProjectSettings.class);
            toPerform.idea(this.project, model, ideaExt);
        });
    }

    public void onEclipse(EclipseIdeImportAction toPerform) {
        this.project.getPlugins().withType(EclipsePlugin.class, plugin -> {
            if (!this.isEclipseImport()) {
                return;
            }
            EclipseModel model = (EclipseModel)this.project.getExtensions().findByType(EclipseModel.class);
            if (model == null) {
                model = (EclipseModel)this.rootProject.getExtensions().findByType(EclipseModel.class);
                return;
            }
            toPerform.eclipse(this.project, model);
        });
    }

    public void onGradle(GradleIdeImportAction toPerform) {
        if (!this.isEclipseImport() && !this.isIdeaImport()) {
            toPerform.gradle(this.project);
        }
    }

    public static interface IdeImportAction
    extends IdeaIdeImportAction,
    EclipseIdeImportAction,
    GradleIdeImportAction {
    }

    public static interface EclipseIdeImportAction {
        public void eclipse(Project var1, EclipseModel var2);
    }

    public static interface IdeaIdeImportAction {
        public void idea(Project var1, IdeaModel var2, ProjectSettings var3);
    }

    public static interface GradleIdeImportAction {
        default public void gradle(Project project) {
        }
    }
}

