/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.cache;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.services.caching.cache.ICache;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;
import net.neoforged.gradle.common.services.caching.locking.LockManager;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;
import net.neoforged.gradle.common.util.hash.Hashing;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;

public class FileCache
implements ICache {
    private final File cacheDir;

    public FileCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public void loadFrom(File file) throws IOException {
        File cacheFile = new File(this.cacheDir, "output");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        if (!file.exists()) {
            return;
        }
        FileUtils.copyFile((File)file, (File)cacheFile);
    }

    @Override
    public boolean restoreTo(File file) throws IOException {
        File cacheFile = new File(this.cacheDir, "output");
        if (file.exists()) {
            if (file.isFile() && cacheFile.exists() && Hashing.hashFile(file).equals(Hashing.hashFile(cacheFile))) {
                return false;
            }
            if (file.isDirectory()) {
                FileUtils.cleanDirectory((File)file);
            }
            file.delete();
        }
        if (cacheFile.exists()) {
            try {
                FileUtils.copyFile((File)cacheFile, (File)file);
            }
            catch (IOException e) {
                throw new GradleException("Failed to restore cache. Copying of the cache file failed.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public FileBasedLock createLock(CacheLogger logger) {
        return LockManager.createLock(this.cacheDir, logger);
    }
}

