/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.dsl.common.tasks.Execute;
import net.neoforged.gradle.dsl.common.tasks.specifications.ExecuteSpecification;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class DefaultExecute
extends DefaultRuntime
implements Execute {
    public DefaultExecute() {
        this.getLogFileName().convention(this.getArguments().getOrDefault("log", this.getProviderFactory().provider(() -> "log.log")).orElse((Object)"log.log"));
        this.getLogFile().convention(this.getOutputDirectory().flatMap(d -> this.getLogFileName().map(arg_0 -> ((Directory)d).file(arg_0))));
        this.getConsoleLogFileName().convention(this.getArguments().getOrDefault("console.log", this.getProviderFactory().provider(() -> "console.log")));
        this.getConsoleLogFile().convention(this.getOutputDirectory().flatMap(d -> this.getConsoleLogFileName().map(arg_0 -> ((Directory)d).file(arg_0))));
        this.getMainClass().convention(this.getExecutingJar().map(TransformerUtils.guardWithResource(jarFile -> jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS), f -> new JarFile(f.getAsFile()))));
        this.getRuntimeProgramArguments().convention(this.getProgramArguments());
        this.getMultiRuntimeArguments().convention(this.getMultiArguments().AsMap());
        this.getLogLevel().convention((Object)ExecuteSpecification.LogLevel.ERROR);
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void execute() throws Throwable {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.file(this.getOutput(), () -> ((DefaultExecute)this).doExecute())).execute();
    }

    @Input
    public abstract Property<String> getConsoleLogFileName();

    @Input
    public abstract Property<String> getLogFileName();

    @Input
    public abstract ListProperty<String> getProgramArguments();

    @Override
    public void buildRuntimeArguments(Map<String, Provider<String>> arguments) {
        super.buildRuntimeArguments(arguments);
        arguments.computeIfAbsent("log", k -> this.newProvider(((RegularFile)this.getLogFile().get()).getAsFile().getAbsolutePath()));
        arguments.computeIfAbsent("console.log", k -> this.newProvider(((RegularFile)this.getConsoleLogFile().get()).getAsFile().getAbsolutePath()));
    }
}

