/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.minecraftforge.gdi.annotations.DSLProperty;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.runs.run.RunSourceSets;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;

public abstract class RunSourceSetsImpl
implements RunSourceSets {
    private final Project project;
    private final Multimap<String, SourceSet> sourceSets;
    private final List<Action<SourceSet>> callbacks = new ArrayList<Action<SourceSet>>();
    private final List<Provider<Multimap<String, SourceSet>>> sourceSetProviders = new ArrayList<Provider<Multimap<String, SourceSet>>>();

    @Inject
    public RunSourceSetsImpl(Project project) {
        this.project = project;
        this.sourceSets = HashMultimap.create();
    }

    public void add(SourceSet sourceSet) {
        this.sourceSets.put((Object)SourceSetUtils.getModIdentifier(sourceSet, null), (Object)sourceSet);
        for (Action<SourceSet> callback : this.callbacks) {
            callback.execute((Object)sourceSet);
        }
    }

    public void add(Iterable<? extends SourceSet> sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.add(sourceSet);
        }
    }

    public void add(SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.add(sourceSet);
        }
    }

    public void local(SourceSet sourceSet) {
        this.sourceSets.put((Object)SourceSetUtils.getModIdentifier(sourceSet, this.project), (Object)sourceSet);
        for (Action<SourceSet> callback : this.callbacks) {
            callback.execute((Object)sourceSet);
        }
    }

    public void local(Iterable<? extends SourceSet> sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.local(sourceSet);
        }
    }

    public void local(SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.local(sourceSet);
        }
    }

    public void add(String groupId, SourceSet sourceSet) {
        this.sourceSets.put((Object)groupId, (Object)sourceSet);
        for (Action<SourceSet> callback : this.callbacks) {
            callback.execute((Object)sourceSet);
        }
    }

    public void add(String groupId, Iterable<? extends SourceSet> sourceSets) {
        this.sourceSets.putAll((Object)groupId, sourceSets);
        for (SourceSet sourceSet : sourceSets) {
            for (Action<SourceSet> callback : this.callbacks) {
                callback.execute((Object)sourceSet);
            }
        }
    }

    public void add(String groupId, SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.add(groupId, sourceSet);
        }
    }

    public void addAllLater(Provider<Multimap<String, SourceSet>> sourceSets) {
        this.sourceSetProviders.add(sourceSets);
    }

    @Input
    @Optional
    @DSLProperty
    public abstract Property<SourceSet> getPrimary();

    public Provider<Multimap<String, SourceSet>> all() {
        if (!this.sourceSetProviders.isEmpty()) {
            for (Provider<Multimap<String, SourceSet>> sourceSetProvider : this.sourceSetProviders) {
                Multimap sourceSets = (Multimap)sourceSetProvider.get();
                sourceSets.forEach(this::add);
            }
            this.sourceSetProviders.clear();
        }
        return this.project.provider(() -> this.sourceSets);
    }

    public void whenSourceSetAdded(Action<SourceSet> action) {
        this.callbacks.add(action);
        for (SourceSet value : this.sourceSets.values()) {
            action.execute((Object)value);
        }
    }
}

