/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.base;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;

public abstract class WithPropertyLookup {
    protected final Project project;

    public WithPropertyLookup(Project project) {
        this.project = project;
    }

    protected Provider<String> getStringProperty(String propertyName, String defaultValue) {
        Provider property = this.project.getProviders().gradleProperty("neogradle.subsystems." + propertyName);
        if (defaultValue == null) {
            return property;
        }
        return property.orElse((Object)defaultValue);
    }

    protected Provider<Directory> getDirectoryProperty(String propertyName, Provider<Directory> defaultValue) {
        return this.project.getProviders().gradleProperty("neogradle.subsystems." + propertyName).flatMap(path -> this.project.getLayout().dir(this.project.provider(() -> new File((String)path)))).orElse(defaultValue);
    }

    protected Provider<Boolean> getBooleanProperty(String propertyName, boolean defaultValue, boolean disabledValue) {
        String fullPropertyName = "neogradle.subsystems." + propertyName;
        return this.project.getProviders().gradleProperty(fullPropertyName).map(value -> {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e) {
                throw new GradleException("Gradle Property " + fullPropertyName + " is not set to a boolean value: '" + value + "'");
            }
        }).orElse((Object)defaultValue);
    }

    protected Provider<List<String>> getSpaceSeparatedListProperty(String propertyName, List<String> defaultValue) {
        return this.project.getProviders().gradleProperty("neogradle.subsystems." + propertyName).map(s -> Arrays.asList(s.split("\\s+"))).orElse(defaultValue);
    }

    public Project getProject() {
        return this.project;
    }
}

