/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import java.util.function.BiConsumer;
import javax.inject.Inject;
import net.neoforged.gradle.common.tasks.IdePostSyncExecutionTask;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.IDE;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.ide.IDEA;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.gradle.ext.IdeaExtPlugin;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.TaskTriggersConfig;

public abstract class IdeManagementExtension {
    public static final String IDE_POST_SYNC_TASK_NAME = "idePostSync";
    private final Project project;
    private final Project rootProject;

    @Inject
    public IdeManagementExtension(Project project) {
        this.project = project;
        this.rootProject = project.getRootProject();
        project.getPlugins().apply(IdeaExtPlugin.class);
        project.getPlugins().apply(EclipsePlugin.class);
        if (project != this.rootProject) {
            if (!this.rootProject.getPlugins().hasPlugin(IdeaExtPlugin.class)) {
                this.rootProject.getPlugins().apply(IdeaExtPlugin.class);
            }
            if (!this.rootProject.getPlugins().hasPlugin(EclipsePlugin.class)) {
                this.rootProject.getPlugins().apply(EclipsePlugin.class);
            }
        }
        if (this.isIdeaAttached() && this.isIdeaSyncing()) {
            this.getOrCreateIdeImportTask();
        }
    }

    public boolean isIdeaAttached() {
        return Boolean.getBoolean("idea.active");
    }

    public boolean isIdeaSyncing() {
        return Boolean.getBoolean("idea.sync.active");
    }

    public boolean isEclipseImport() {
        return System.getProperty("eclipse.application") != null;
    }

    public boolean isVscodeImport() {
        boolean isNativeEclipse = this.isEclipseImport() && System.getProperty("eclipse.home.location", "").contains("redhat.java");
        return isNativeEclipse || IdeManagementExtension.isVscodePluginImport(this.project);
    }

    public static boolean isVscodePluginImport(Project project) {
        return project.getPlugins().stream().anyMatch(p -> p.getClass().getName().equals("com.microsoft.gradle.GradlePlugin"));
    }

    public boolean isIdeImportInProgress() {
        return this.isIdeaAttached() || this.isEclipseImport() || this.isVscodeImport();
    }

    public void registerTaskToRun(TaskProvider<?> taskToRun) {
        TaskProvider<? extends IdePostSyncExecutionTask> idePostSyncTask = this.getOrCreateIdeImportTask();
        idePostSyncTask.configure(task -> task.dependsOn(new Object[]{taskToRun}));
    }

    public void registerTaskToRun(Task taskToRun) {
        TaskProvider<? extends IdePostSyncExecutionTask> idePostSyncTask = this.getOrCreateIdeImportTask();
        idePostSyncTask.configure(task -> task.dependsOn(new Object[]{taskToRun}));
    }

    @NotNull
    public TaskProvider<? extends IdePostSyncExecutionTask> getOrCreateIdeImportTask() {
        TaskProvider idePostSyncTask;
        if (!this.project.getTasks().getNames().contains(IDE_POST_SYNC_TASK_NAME)) {
            idePostSyncTask = this.project.getTasks().register(IDE_POST_SYNC_TASK_NAME, IdePostSyncExecutionTask.class);
            this.apply(new IdeImportAction(){

                @Override
                public void idea(Project project, Project rootProject, IdeaModel idea, ProjectSettings ideaExtension) {
                    Conventions conventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions();
                    IDE ideConventions = conventions.getIde();
                    IDEA ideaConventions = ideConventions.getIdea();
                    if (!((Boolean)ideaConventions.getShouldUsePostSyncTask().get()).booleanValue()) {
                        return;
                    }
                    TaskTriggersConfig taskTriggers = (TaskTriggersConfig)((ExtensionAware)ideaExtension).getExtensions().getByType(TaskTriggersConfig.class);
                    taskTriggers.afterSync(new Object[]{idePostSyncTask});
                }

                @Override
                public void eclipse(Project project, EclipseModel eclipse) {
                    eclipse.synchronizationTasks(new Object[]{idePostSyncTask});
                }

                @Override
                public void vscode(Project project, EclipseModel eclipse) {
                    this.eclipse(project, eclipse);
                }
            });
        } else {
            idePostSyncTask = this.project.getTasks().named(IDE_POST_SYNC_TASK_NAME, IdePostSyncExecutionTask.class);
        }
        return idePostSyncTask;
    }

    public void apply(IdeImportAction toPerform) {
        this.onIdea(toPerform);
        if (this.isVscodeImport()) {
            this.onVscode(toPerform);
        } else {
            this.onEclipse(toPerform);
        }
        this.onGradle(toPerform);
    }

    public void onIdea(IdeaIdeImportAction toPerform) {
        this.project.getPlugins().withType(IdeaExtPlugin.class, plugin -> {
            if (!this.isIdeaAttached()) {
                return;
            }
            IdeaModel model = (IdeaModel)this.project.getExtensions().findByType(IdeaModel.class);
            if (model == null || model.getProject() == null) {
                model = (IdeaModel)this.rootProject.getExtensions().findByType(IdeaModel.class);
            }
            if (model == null || model.getProject() == null) {
                throw new IllegalStateException("IDEA model is null, even though the IDEA plugin is applied.");
            }
            ProjectSettings ideaExt = (ProjectSettings)((ExtensionAware)model.getProject()).getExtensions().getByType(ProjectSettings.class);
            toPerform.idea(this.project, this.rootProject, model, ideaExt);
        });
    }

    public void onEclipse(EclipseIdeImportAction toPerform) {
        this.onCommonEclipse(toPerform::eclipse);
    }

    public void onVscode(VscodeIdeImportAction toPerform) {
        this.onCommonEclipse(toPerform::vscode);
    }

    private void onCommonEclipse(BiConsumer<Project, EclipseModel> toPerform) {
        this.project.getPlugins().withType(EclipsePlugin.class, plugin -> {
            if (!this.isEclipseImport()) {
                return;
            }
            EclipseModel model = this.getEclipseModel();
            if (model == null) {
                return;
            }
            toPerform.accept(this.project, model);
        });
    }

    @Nullable
    public EclipseModel getEclipseModel() {
        EclipseModel model = (EclipseModel)this.project.getExtensions().findByType(EclipseModel.class);
        if (model == null) {
            model = (EclipseModel)this.project.getRootProject().getExtensions().findByType(EclipseModel.class);
        }
        return model;
    }

    public void onGradle(GradleIdeImportAction toPerform) {
        if (!(this.isEclipseImport() || this.isIdeaAttached() || this.isVscodeImport())) {
            toPerform.gradle(this.project);
        }
    }

    public static interface IdeImportAction
    extends IdeaIdeImportAction,
    EclipseIdeImportAction,
    VscodeIdeImportAction,
    GradleIdeImportAction {
    }

    public static interface IdeaIdeImportAction {
        public void idea(Project var1, Project var2, IdeaModel var3, ProjectSettings var4);
    }

    public static interface VscodeIdeImportAction {
        public void vscode(Project var1, EclipseModel var2);
    }

    public static interface EclipseIdeImportAction {
        public void eclipse(Project var1, EclipseModel var2);
    }

    public static interface GradleIdeImportAction {
        default public void gradle(Project project) {
        }
    }
}

