/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class BundledServerUtils {
    private BundledServerUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: BundledServerUtils. This is a utility class");
    }

    public static boolean isBundledServer(File serverJar) {
        boolean bl;
        ZipFile file = new ZipFile(serverJar);
        try {
            bl = file.getEntry("META-INF/classpath-joined") != null && file.getEntry("META-INF/libraries.list") != null && file.getEntry("META-INF/versions.list") != null && file.getEntry("META-INF/main-class") != null && file.getEntry("versions.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        file.close();
        return bl;
    }

    public static List<String> getBundledDependencies(File serverJar) {
        List<String> list;
        ZipFile file = new ZipFile(serverJar);
        try {
            InputStream inputStream = file.getInputStream(file.getEntry("META-INF/libraries.list"));
            List dependencies = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset());
            inputStream.close();
            list = dependencies.stream().map(l -> l.split("\\s+")).filter(l -> ((String[])l).length >= 2).map(l -> l[1]).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read libraries.list from server jar", e);
            }
        }
        file.close();
        return list;
    }

    @Nullable
    public static String getBundledMainClass(File serverJar) {
        String string;
        if (!BundledServerUtils.isBundledServer(serverJar)) {
            return null;
        }
        ZipFile file = new ZipFile(serverJar);
        try {
            InputStream inputStream = file.getInputStream(file.getEntry("META-INF/main-class"));
            String mainClass = (String)IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset()).get(0);
            inputStream.close();
            string = mainClass;
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read main-class from server jar", e);
            }
        }
        file.close();
        return string;
    }

    public static String getBundledVersion(File serverJar) {
        String string;
        ZipFile file = new ZipFile(serverJar);
        try {
            InputStream inputStream = file.getInputStream(file.getEntry("META-INF/versions.list"));
            List dependencies = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset());
            inputStream.close();
            string = dependencies.stream().map(l -> l.split("\\s+")).filter(l -> ((String[])l).length >= 2).map(l -> l[1]).findFirst().orElseThrow(() -> new RuntimeException("Failed to find version in versions.list"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read libraries.list from server jar", e);
            }
        }
        file.close();
        return string;
    }

    public static void extractBundledVersion(File serverJar, File outputFile) {
        try (ZipFile file = new ZipFile(serverJar);
             FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            String versionName = BundledServerUtils.getBundledVersion(serverJar);
            String jarPath = "META-INF/versions/" + versionName + "/" + versionName + ".jar";
            InputStream jarStream = file.getInputStream(file.getEntry(jarPath));
            IOUtils.copy((InputStream)jarStream, (OutputStream)fileOutputStream);
            jarStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read libraries.list from server jar", e);
        }
    }
}

