/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.cache;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.services.caching.cache.ICache;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;
import net.neoforged.gradle.common.services.caching.locking.LockManager;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;
import net.neoforged.gradle.common.util.hash.Hashing;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;

public class DirectoryCache
implements ICache {
    private final File cacheDir;

    public DirectoryCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public void loadFrom(File file) throws IOException {
        if (file.exists()) {
            File output = new File(this.cacheDir, "output");
            if (!output.exists()) {
                output.mkdirs();
            }
            FileUtils.cleanDirectory((File)output);
            FileUtils.copyDirectory((File)file, (File)output);
        }
    }

    @Override
    public boolean restoreTo(File file) throws IOException {
        File output = new File(this.cacheDir, "output");
        if (file.exists()) {
            if (file.isDirectory() && output.exists() && Hashing.hashDirectory(file).equals(Hashing.hashDirectory(output))) {
                return false;
            }
            if (file.isDirectory()) {
                FileUtils.cleanDirectory((File)file);
            }
            file.delete();
        }
        file.mkdirs();
        if (output.exists()) {
            try {
                FileUtils.copyDirectory((File)output, (File)file);
            }
            catch (IOException e) {
                throw new GradleException("Failed to restore cache.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public FileBasedLock createLock(CacheLogger logger) {
        return LockManager.createLock(this.cacheDir, logger);
    }
}

