/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.extensions;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.RuntimesExtension;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.extensions.CommonRuntimes;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonRuntimeExtension<S extends CommonRuntimeSpecification, B extends CommonRuntimeSpecification.Builder<S, B>, D extends CommonRuntimeDefinition<S>>
implements CommonRuntimes<S, B, D> {
    protected final Map<String, D> definitions = Maps.newHashMap();
    protected final Map<String, Dependency> dependencies = Maps.newHashMap();
    private final Project project;

    protected CommonRuntimeExtension(Project project) {
        this.project = project;
        ((RuntimesExtension)this.project.getExtensions().getByType(RuntimesExtension.class)).add(this);
    }

    public static void configureCommonRuntimeTaskParameters(Runtime runtimeTask, Map<String, String> symbolicDataSources, String step, Specification spec, File runtimeDirectory) {
        runtimeTask.getSymbolicDataSources().set(symbolicDataSources);
        runtimeTask.getStepName().set((Object)step);
        runtimeTask.getDistribution().set((Object)spec.getDistribution());
        runtimeTask.getMinecraftVersion().set((Object)CacheableMinecraftVersion.from((String)spec.getMinecraftVersion(), (Project)spec.getProject()).getFull());
        runtimeTask.getRuntimeDirectory().set(runtimeDirectory);
        runtimeTask.getRuntimeName().set((Object)spec.getVersionedName());
        runtimeTask.getJavaVersion().convention((Provider)((JavaPluginExtension)spec.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        for (TaskCustomizer taskCustomizer : spec.getTaskCustomizers().get((Object)step)) {
            taskCustomizer.apply(runtimeTask);
        }
    }

    public static void configureCommonRuntimeTaskParameters(Runtime runtime, CommonRuntimeDefinition<?> runtimeDefinition, File workingDirectory) {
        CommonRuntimeExtension.configureCommonRuntimeTaskParameters(runtime, (CommonRuntimeSpecification)runtimeDefinition.getSpecification(), workingDirectory);
    }

    public static void configureCommonRuntimeTaskParameters(Runtime runtime, String stepName, CommonRuntimeSpecification specification, File workingDirectory) {
        CommonRuntimeExtension.configureCommonRuntimeTaskParameters(runtime, Collections.emptyMap(), stepName, specification, workingDirectory);
    }

    private static void configureCommonRuntimeTaskParameters(Runtime runtime, CommonRuntimeSpecification specification, File workingDirectory) {
        CommonRuntimeExtension.configureCommonRuntimeTaskParameters(runtime, runtime.getName(), specification, workingDirectory);
    }

    public static Map<GameArtifact, TaskProvider<? extends WithOutput>> buildDefaultArtifactProviderTasks(Specification spec) {
        MinecraftArtifactCache artifactCache = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        return artifactCache.cacheGameVersionTasks(spec.getProject(), spec.getMinecraftVersion(), spec.getDistribution());
    }

    public Project getProject() {
        return this.project;
    }

    public final Map<String, D> getDefinitions() {
        return this.definitions;
    }

    @Deprecated
    public final Provider<Map<String, D>> getRuntimes() {
        return this.project.provider(this::getDefinitions);
    }

    @NotNull
    public final D maybeCreate(Action<B> configurator) {
        S spec = this.createSpec(configurator);
        if (this.definitions.containsKey(((CommonRuntimeSpecification)spec).getIdentifier())) {
            return (D)((CommonRuntimeDefinition)this.definitions.get(((CommonRuntimeSpecification)spec).getIdentifier()));
        }
        return (D)this.create((Action)configurator);
    }

    public D maybeCreateFor(Dependency dependency, Action<B> configurator) {
        Definition result = this.maybeCreate((Action)configurator);
        this.dependencies.put(result.getSpecification().getIdentifier(), dependency);
        return (D)result;
    }

    @NotNull
    public final D create(Action<B> configurator) {
        S spec = this.createSpec(configurator);
        if (((RuntimesExtension)this.project.getExtensions().getByType(RuntimesExtension.class)).definitionExists(((CommonRuntimeSpecification)spec).getIdentifier())) {
            throw new IllegalArgumentException(String.format("Runtime with identifier '%s' already exists", ((CommonRuntimeSpecification)spec).getIdentifier()));
        }
        D runtime = this.doCreate(spec);
        this.definitions.put(((CommonRuntimeSpecification)spec).getIdentifier(), runtime);
        this.afterRegistration(runtime);
        return runtime;
    }

    protected void afterRegistration(D runtime) {
    }

    public D create(Dependency dependency, Action<B> configurator) {
        Definition result = this.create((Action)configurator);
        this.dependencies.put(result.getSpecification().getIdentifier(), dependency);
        return (D)result;
    }

    @NotNull
    protected abstract D doCreate(S var1);

    @NotNull
    private S createSpec(Action<B> configurator) {
        B builder = this.createBuilder();
        configurator.execute(builder);
        return ((CommonRuntimeSpecification.Builder)builder).build();
    }

    @NotNull
    public final D getByName(String name) {
        return (D)this.definitions.computeIfAbsent(name, n -> {
            throw new RuntimeException(String.format("Failed to find runtime with name: %s", n));
        });
    }

    @Nullable
    public final D findByNameOrIdentifier(String name) {
        CommonRuntimeDefinition byIdentifier = (CommonRuntimeDefinition)this.definitions.get(name);
        if (byIdentifier != null) {
            return (D)byIdentifier;
        }
        return (D)((CommonRuntimeDefinition)this.definitions.values().stream().filter(r -> r.getSpecification().getVersionedName().equals(name)).findAny().orElse(null));
    }

    protected abstract B createBuilder();

    @NotNull
    public Set<D> findIn(Configuration configuration) {
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        Set directDependency = configuration.getAllDependencies().stream().flatMap(dep -> this.getDefinitions().values().stream().filter(runtime -> this.dependencies.containsKey(runtime.getSpecification().getIdentifier())).filter(runtime -> repository.getEntries().stream().anyMatch(entry -> entry.getOriginal().equals(this.dependencies.get(runtime.getSpecification().getIdentifier()))))).collect(Collectors.toSet());
        if (!directDependency.isEmpty()) {
            return directDependency;
        }
        return this.project.getConfigurations().stream().filter(config -> config.getHierarchy().contains(configuration)).flatMap(config -> config.getAllDependencies().stream()).flatMap(dep -> this.getDefinitions().values().stream().filter(runtime -> this.dependencies.containsKey(runtime.getSpecification().getIdentifier())).filter(runtime -> repository.getEntries().stream().anyMatch(entry -> entry.getOriginal().equals(this.dependencies.get(runtime.getSpecification().getIdentifier()))))).collect(Collectors.toSet());
    }

    protected final TaskProvider<DownloadAssets> createDownloadAssetsTasks(CommonRuntimeSpecification specification, Provider<VersionJson> versionJson) {
        return specification.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)specification, (String)"downloadAssets"), DownloadAssets.class, task -> task.getVersionJson().set(versionJson));
    }

    protected final TaskProvider<ExtractNatives> createExtractNativesTasks(CommonRuntimeSpecification specification, Map<String, String> symbolicDataSources, File runtimeDirectory, Provider<VersionJson> versionJson) {
        return specification.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)specification, (String)"extractNatives"), ExtractNatives.class, task -> {
            task.getVersionJson().set(versionJson);
            CommonRuntimeExtension.configureCommonRuntimeTaskParameters(task, symbolicDataSources, "extractNatives", specification, runtimeDirectory);
            task.getOutputDirectory().set(task.getStepsDirectory().map(dir -> dir.dir("extractNatives")));
        });
    }

    protected final TaskProvider<ExtractNatives> createExtractNativesTasks(CommonRuntimeSpecification specification, File runtimeDirectory, Provider<VersionJson> versionJson) {
        return this.createExtractNativesTasks(specification, Collections.emptyMap(), runtimeDirectory, versionJson);
    }
}

