/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.extensions.repository.Entry;
import org.gradle.api.artifacts.ComponentMetadataBuilder;
import org.gradle.api.artifacts.ComponentMetadataSupplier;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.provider.Provider;

public class IvyMetadata
implements ComponentMetadataSupplier {
    private final Provider<Set<MetadataEntry>> repoEntries;

    @Inject
    public IvyMetadata(Provider<Set<MetadataEntry>> repoEntries) {
        this.repoEntries = repoEntries;
    }

    public void execute(ComponentMetadataSupplierDetails details) {
        ModuleComponentIdentifier id = details.getId();
        ComponentMetadataBuilder result = details.getResult();
        Optional<MetadataEntry> entryCandidate = ((Set)this.repoEntries.get()).stream().filter(metadataEntry -> metadataEntry.matches(id)).findFirst();
        if (!entryCandidate.isPresent()) {
            return;
        }
        result.setStatus("Found");
        result.setStatusScheme((List)Lists.newArrayList((Object[])new String[]{"Found", "Not Found"}));
    }

    public static final class MetadataEntry
    implements Serializable {
        private final String group;
        private final String name;
        private final String version;

        public static MetadataEntry from(Entry entry) {
            return new MetadataEntry(entry.getDependency().getGroup(), entry.getDependency().getName(), entry.getDependency().getVersion());
        }

        private MetadataEntry(String group, String name, String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        private boolean matches(ModuleComponentIdentifier id) {
            return this.group.equals(id.getGroup()) && this.name.equals(id.getModule()) && this.version.equals(id.getVersion());
        }
    }
}

