/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.problems;

import javax.inject.Inject;
import net.neoforged.gradle.common.extensions.problems.IProblemReporter;
import net.neoforged.gradle.common.extensions.problems.NeoGradleProblemSpec;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.logging.Logger;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.Severity;

public class IntegratedProblemReporter
implements IProblemReporter {
    private final ProblemReporter delegate;

    @Inject
    public IntegratedProblemReporter(ProblemReporter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void reporting(Action<NeoGradleProblemSpec> spec, Logger logger) {
        this.delegate.reporting(problemSpec -> {
            NeoGradleProblemSpec neoGradleProblemSpec = new NeoGradleProblemSpec();
            spec.execute((Object)neoGradleProblemSpec);
            problemSpec.id(neoGradleProblemSpec.category(), neoGradleProblemSpec.id()).contextualLabel(neoGradleProblemSpec.contextualLabel()).solution(neoGradleProblemSpec.solution()).details(neoGradleProblemSpec.details()).severity(Severity.WARNING).documentedAt(neoGradleProblemSpec.documentedAt());
            neoGradleProblemSpec.log(logger);
        });
    }

    @Override
    public RuntimeException throwing(Action<NeoGradleProblemSpec> spec) {
        return this.delegate.throwing(problemSpec -> {
            NeoGradleProblemSpec neoGradleProblemSpec = new NeoGradleProblemSpec();
            spec.execute((Object)neoGradleProblemSpec);
            problemSpec.id(neoGradleProblemSpec.category(), neoGradleProblemSpec.id()).contextualLabel(neoGradleProblemSpec.contextualLabel()).solution(neoGradleProblemSpec.solution()).details(neoGradleProblemSpec.details()).severity(Severity.ERROR).withException((RuntimeException)new InvalidUserDataException("(%s) %s.\nPotential Solution: %s.\nMore information: %s".formatted(neoGradleProblemSpec.contextualLabel(), neoGradleProblemSpec.details(), neoGradleProblemSpec.solution(), neoGradleProblemSpec.documentedAt()))).documentedAt(neoGradleProblemSpec.documentedAt());
        });
    }
}

