/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common;

import javax.inject.Inject;
import net.neoforged.gradle.common.accesstransformers.AccessTransformerPublishing;
import net.neoforged.gradle.common.conventions.ConventionConfigurator;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.extensions.AccessTransformersExtension;
import net.neoforged.gradle.common.extensions.ConfigurationDataExtension;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.InterfaceInjectionsExtension;
import net.neoforged.gradle.common.extensions.MappingsExtension;
import net.neoforged.gradle.common.extensions.MinecraftArtifactCacheExtension;
import net.neoforged.gradle.common.extensions.MinecraftExtension;
import net.neoforged.gradle.common.extensions.ProjectEvaluationExtension;
import net.neoforged.gradle.common.extensions.ProjectHolderExtension;
import net.neoforged.gradle.common.extensions.dependency.replacement.ReplacementLogic;
import net.neoforged.gradle.common.extensions.problems.ProblemReportingConfigurator;
import net.neoforged.gradle.common.extensions.repository.IvyRepository;
import net.neoforged.gradle.common.extensions.sourcesets.SourceSetDependencyExtensionImpl;
import net.neoforged.gradle.common.extensions.sourcesets.SourceSetInheritanceExtensionImpl;
import net.neoforged.gradle.common.extensions.subsystems.SubsystemsExtension;
import net.neoforged.gradle.common.interfaceinjection.InterfaceInjectionPublishing;
import net.neoforged.gradle.common.rules.LaterAddedReplacedDependencyRule;
import net.neoforged.gradle.common.runs.ide.IdeRunIntegrationManager;
import net.neoforged.gradle.common.runs.run.RunManagerImpl;
import net.neoforged.gradle.common.runs.run.RunTypeManagerImpl;
import net.neoforged.gradle.common.runs.tasks.RunsReport;
import net.neoforged.gradle.common.runs.unittest.UnitTestConfigurator;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.RuntimesExtension;
import net.neoforged.gradle.common.runtime.naming.OfficialNamingChannelConfigurator;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.tasks.CleanCache;
import net.neoforged.gradle.common.tasks.DisplayMappingsLicenseTask;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.ConfigurationData;
import net.neoforged.gradle.dsl.common.extensions.InterfaceInjections;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.ProjectHolder;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.extensions.sourceset.RunnableSourceSet;
import net.neoforged.gradle.dsl.common.extensions.sourceset.SourceSetDependencyExtension;
import net.neoforged.gradle.dsl.common.extensions.sourceset.SourceSetInheritanceExtension;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.problems.Problems;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.jetbrains.gradle.ext.IdeaExtPlugin;

public class CommonProjectPlugin
implements Plugin<Project> {
    private final Problems problems;

    @Inject
    public CommonProjectPlugin(Problems problems) {
        this.problems = problems;
    }

    public void apply(Project project) {
        project.getExtensions().create("evaluation", ProjectEvaluationExtension.class, new Object[]{project});
        project.getPluginManager().apply(JavaPlugin.class);
        CachedExecutionService.register(project);
        project.getPluginManager().apply(IdeaPlugin.class);
        project.getRootProject().getPluginManager().apply(IdeaExtPlugin.class);
        project.getPluginManager().apply(IdeaExtPlugin.class);
        project.getPluginManager().apply(EclipsePlugin.class);
        project.getExtensions().create(Subsystems.class, "subsystems", SubsystemsExtension.class, new Object[]{project});
        project.getExtensions().create(IdeManagementExtension.class, "ideManager", IdeManagementExtension.class, new Object[]{project});
        project.getExtensions().create("allRuntimes", RuntimesExtension.class, new Object[0]);
        project.getExtensions().create(Repository.class, "ivyDummyRepository", IvyRepository.class, new Object[]{project});
        project.getExtensions().create(MinecraftArtifactCache.class, "minecraftArtifactCache", MinecraftArtifactCacheExtension.class, new Object[]{project});
        project.getExtensions().create(DependencyReplacement.class, "dependencyReplacements", ReplacementLogic.class, new Object[]{project});
        project.getExtensions().create(AccessTransformers.class, "accessTransformers", AccessTransformersExtension.class, new Object[]{project});
        project.getExtensions().create(InterfaceInjections.class, "interfaceInjections", InterfaceInjectionsExtension.class, new Object[]{project});
        project.getExtensions().create(Minecraft.class, "minecraft", MinecraftExtension.class, new Object[]{project});
        project.getExtensions().create(Mappings.class, "mappings", MappingsExtension.class, new Object[]{project});
        project.getExtensions().create(RunTypeManager.class, "runTypeManager", RunTypeManagerImpl.class, new Object[]{project});
        project.getExtensions().create(ExtraJarDependencyManager.class, "clientExtraJarDependencyManager", ExtraJarDependencyManager.class, new Object[]{project});
        project.getExtensions().create(RunManager.class, "runManager", RunManagerImpl.class, new Object[]{project});
        ProblemReportingConfigurator.configureProblemReporting(project, this.problems);
        ConfigurationData configurationData = (ConfigurationData)project.getExtensions().create(ConfigurationData.class, "configurationData", ConfigurationDataExtension.class, new Object[]{project});
        OfficialNamingChannelConfigurator.getInstance().configure(project);
        project.getTasks().register("handleNamingLicense", DisplayMappingsLicenseTask.class, task -> task.getLicense().set(project.provider(() -> {
            Mappings mappings = (Mappings)project.getExtensions().getByType(Mappings.class);
            if (((Boolean)((NamingChannel)mappings.getChannel().get()).getHasAcceptedLicense().get()).booleanValue()) {
                return null;
            }
            return (String)((NamingChannel)mappings.getChannel().get()).getLicenseText().get();
        })));
        project.getRepositories().maven(e -> {
            e.setUrl((Object)"https://libraries.minecraft.net/");
            e.metadataSources(MavenArtifactRepository.MetadataSources::mavenPom);
        });
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> {
            sourceSet.getExtensions().create(ProjectHolder.class, "projectHolder", ProjectHolderExtension.class, new Object[]{project});
            sourceSet.getExtensions().create("runs", RunnableSourceSet.class, new Object[]{project});
            sourceSet.getExtensions().create(SourceSetDependencyExtension.class, "depends", SourceSetDependencyExtensionImpl.class, new Object[]{sourceSet});
            sourceSet.getExtensions().create(SourceSetInheritanceExtension.class, "inherits", SourceSetInheritanceExtensionImpl.class, new Object[]{sourceSet});
            sourceSet.getExtensions().add("runtimeDefinition", (Object)project.getObjects().property(CommonRuntimeDefinition.class));
        });
        ConfigurationUtils.ensureReplacementConfigurationExists(project);
        UnitTestConfigurator.configureIdeUnitTests(project);
        project.getTasks().addRule((Rule)new LaterAddedReplacedDependencyRule(project));
        AccessTransformerPublishing.setup(project);
        InterfaceInjectionPublishing.setup(project);
        IdeRunIntegrationManager.getInstance().setup(project);
        project.getTasks().register("cleanCache", CleanCache.class);
        project.getTasks().named("clean", Delete.class, delete -> delete.delete(new Object[]{configurationData.getLocation()}));
        project.getTasks().register("runs", RunsReport.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        sourceSets.all(ConfigurationUtils::getSdkConfiguration);
        ConventionConfigurator.configureConventions(project);
        project.afterEvaluate(this::applyAfterEvaluate);
    }

    private void applyAfterEvaluate(Project project) {
        RunManager runs = (RunManager)project.getExtensions().getByType(RunManager.class);
        runs.realizeAll(run -> RunsUtil.configure(project, run, !runs.getNames().contains(run.getName())));
        IdeRunIntegrationManager.getInstance().apply(project);
    }
}

