/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util.run;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runs.tasks.RunExec;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Runs;
import net.neoforged.gradle.dsl.common.runs.idea.extensions.IdeaRunsExtension;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;

public class RunsUtil {
    private RunsUtil() {
        throw new IllegalStateException("Tried to create utility class!");
    }

    public static String createTaskName(Run run) {
        return RunsUtil.createTaskName(run.getName());
    }

    public static String createTaskName(String prefix, Run run) {
        return RunsUtil.createTaskName(prefix, run.getName());
    }

    public static Run create(Project project, String name) {
        RunImpl run = (RunImpl)project.getObjects().newInstance(RunImpl.class, new Object[]{project, name});
        project.afterEvaluate(evaluatedProject -> {
            Provider sourceSets = run.getModSources().all().zip(run.getUnitTestSources().all(), (modSources, unitTestSources) -> {
                if (!((Boolean)run.getIsJUnit().get()).booleanValue()) {
                    return modSources;
                }
                HashMultimap combined = HashMultimap.create((Multimap)modSources);
                combined.putAll(unitTestSources);
                return combined;
            });
            run.getEnvironmentVariables().put((Object)"MOD_CLASSES", RunsUtil.buildGradleModClasses((Provider<Multimap<String, SourceSet>>)sourceSets));
        });
        project.afterEvaluate(evaluatedProject -> {
            if (!((Boolean)run.getIsJUnit().get()).booleanValue()) {
                project.getTasks().register(RunsUtil.createTaskName(name), RunExec.class, runExec -> {
                    runExec.getRun().set((Object)run);
                    RunsUtil.addRunSourcesDependenciesToTask((Task)runExec, run);
                    run.getTaskDependencies().forEach(xva$0 -> runExec.dependsOn(new Object[]{xva$0}));
                });
            } else {
                RunsUtil.createOrReuseTestTask(project, name, run);
            }
        });
        return run;
    }

    private static void createOrReuseTestTask(Project project, String name, RunImpl run) {
        Runs runsConventions;
        Set currentProjectsModSources = ((Multimap)run.getModSources().all().get()).values().stream().filter(sourceSet -> SourceSetUtils.getProject(sourceSet).equals(project)).collect(Collectors.toSet());
        Set currentProjectsTestSources = ((Multimap)run.getUnitTestSources().all().get()).values().stream().filter(sourceSet -> SourceSetUtils.getProject(sourceSet).equals(project)).collect(Collectors.toSet());
        if (currentProjectsModSources.size() == 1 && currentProjectsModSources.contains(((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")) && currentProjectsTestSources.size() == 1 && currentProjectsTestSources.contains(((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("test")) && ((Boolean)(runsConventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions().getRuns()).getShouldDefaultTestTaskBeReused().get()).booleanValue()) {
            TaskProvider testTask = project.getTasks().named("test", Test.class);
            RunsUtil.configureTestTask(project, (TaskProvider<Test>)testTask, run);
            return;
        }
        RunsUtil.createNewTestTask(project, name, run);
    }

    private static void createNewTestTask(Project project, String name, RunImpl run) {
        TaskProvider newTestTask = project.getTasks().register(RunsUtil.createTaskName("test", name), Test.class);
        RunsUtil.configureTestTask(project, (TaskProvider<Test>)newTestTask, run);
        project.getTasks().named("check", check -> check.dependsOn(new Object[]{newTestTask}));
    }

    private static void configureTestTask(Project project, TaskProvider<Test> testTaskProvider, RunImpl run) {
        testTaskProvider.configure(testTask -> {
            RunsUtil.addRunSourcesDependenciesToTask((Task)testTask, run);
            run.getTaskDependencies().forEach(xva$0 -> testTask.dependsOn(new Object[]{xva$0}));
            testTask.setWorkingDir(run.getWorkingDirectory().get());
            testTask.getSystemProperties().putAll((Map)run.getSystemProperties().get());
            testTask.useJUnitPlatform();
            testTask.setGroup("verification");
            File argsFile = new File(testTask.getWorkingDir(), "test_args.txt");
            ListProperty<String> programArguments = run.getProgramArguments();
            testTask.doFirst("writeArgs", task -> {
                if (!testTask.getWorkingDir().exists()) {
                    testTask.getWorkingDir().mkdirs();
                }
                try {
                    Files.write(argsFile.toPath(), (Iterable<? extends CharSequence>)((Iterable)programArguments.get()), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            testTask.systemProperty("fml.junit.argsfile", (Object)argsFile.getAbsolutePath());
            testTask.getEnvironment().putAll((Map)run.getEnvironmentVariables().get());
            testTask.setJvmArgs((List)run.getJvmArguments().get());
            ConfigurableFileCollection testCP = project.files(new Object[0]);
            testCP.from(new Object[]{((DependencyHandler)run.getDependencies().get()).getRuntimeConfiguration()});
            Stream.concat(((Multimap)run.getModSources().all().get()).values().stream(), ((Multimap)run.getUnitTestSources().all().get()).values().stream()).forEach(src -> testCP.from(new Object[]{RunsUtil.filterOutput(src)}));
            testTask.setClasspath((FileCollection)testCP);
            ConfigurableFileCollection testClassesDirs = project.files(new Object[0]);
            for (SourceSet sourceSet : ((Multimap)run.getUnitTestSources().all().get()).values()) {
                testClassesDirs.from(new Object[]{sourceSet.getOutput().getClassesDirs()});
            }
            testTask.setTestClassesDirs((FileCollection)testClassesDirs);
        });
    }

    private static FileCollection filterOutput(SourceSet srcSet) {
        FileCollection collection = srcSet.getRuntimeClasspath();
        if (srcSet.getOutput().getResourcesDir() != null) {
            File resourcesDir = srcSet.getOutput().getResourcesDir();
            collection = collection.filter(file -> !file.equals(resourcesDir));
        }
        FileCollection classesDirs = srcSet.getOutput().getClassesDirs();
        collection = collection.filter(file -> !classesDirs.contains(file));
        return collection;
    }

    public static void addRunSourcesDependenciesToTask(Task task, Run run) {
        for (SourceSet sourceSet : ((Multimap)run.getModSources().all().get()).values()) {
            Project sourceSetProject = SourceSetUtils.getProject(sourceSet);
            task.dependsOn(new Object[]{sourceSetProject.getTasks().named(sourceSet.getProcessResourcesTaskName())});
            task.dependsOn(new Object[]{sourceSetProject.getTasks().named(sourceSet.getCompileJavaTaskName())});
            sourceSet.getOutput().getBuildDependencies().getDependencies(null).forEach(xva$0 -> task.dependsOn(new Object[]{xva$0}));
        }
    }

    public static Provider<String> buildGradleModClasses(Provider<Multimap<String, SourceSet>> sourceSetsProperty) {
        return RunsUtil.buildGradleModClasses(sourceSetsProperty, sourceSet -> Stream.concat(Stream.of(sourceSet.getOutput().getResourcesDir()), sourceSet.getOutput().getClassesDirs().getFiles().stream()));
    }

    public static Provider<String> buildRunWithIdeaModClasses(Provider<Multimap<String, SourceSet>> sourceSetsProperty) {
        return RunsUtil.buildGradleModClasses(sourceSetsProperty, sourceSet -> {
            Project project = SourceSetUtils.getProject(sourceSet);
            IdeaModel rootIdeaModel = (IdeaModel)project.getRootProject().getExtensions().getByType(IdeaModel.class);
            IdeaRunsExtension ideaRunsExtension = (IdeaRunsExtension)((ExtensionAware)rootIdeaModel.getProject()).getExtensions().getByType(IdeaRunsExtension.class);
            if (((Boolean)ideaRunsExtension.getRunWithIdea().get()).booleanValue()) {
                File parentDir = ((Directory)ideaRunsExtension.getOutDirectory().get()).getAsFile();
                File sourceSetDir = new File(parentDir, RunsUtil.getIntellijOutName(sourceSet));
                return Stream.of(new File(sourceSetDir, "resources"), new File(sourceSetDir, "classes"));
            }
            return Stream.concat(Stream.of(sourceSet.getOutput().getResourcesDir()), sourceSet.getOutput().getClassesDirs().getFiles().stream());
        });
    }

    public static Provider<String> buildRunWithEclipseModClasses(Provider<Multimap<String, SourceSet>> sourceSetsProperty) {
        return RunsUtil.buildGradleModClasses(sourceSetsProperty, sourceSet -> {
            Project project = SourceSetUtils.getProject(sourceSet);
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
            File conventionsDir = new File(project.getProjectDir(), "bin");
            eclipseModel.getClasspath().getBaseSourceOutputDir().convention(project.provider(() -> conventionsDir));
            File parentDir = (File)eclipseModel.getClasspath().getBaseSourceOutputDir().get();
            File sourceSetDir = new File(parentDir, sourceSet.getName());
            return Stream.of(sourceSetDir);
        });
    }

    public static String getIntellijOutName(@Nonnull SourceSet sourceSet) {
        return sourceSet.getName().equals("main") ? "production" : sourceSet.getName();
    }

    public static Provider<String> buildGradleModClasses(Provider<Multimap<String, SourceSet>> sourceSetsProperty, Function<SourceSet, Stream<File>> directoryBuilder) {
        return sourceSetsProperty.map(sourceSetsByRunId -> sourceSetsByRunId.entries().stream().flatMap(entry -> ((Stream)directoryBuilder.apply((SourceSet)entry.getValue())).peek(directory -> directory.mkdirs()).map(directory -> String.format("%s%%%%%s", entry.getKey(), directory.getAbsolutePath()))).collect(Collectors.joining(File.pathSeparator)));
    }

    private static String createTaskName(String runName) {
        return RunsUtil.createTaskName("run", runName);
    }

    private static String createTaskName(String prefix, String runName) {
        String conventionTaskName = runName.replaceAll("[^a-zA-Z0-9\\-_]", "");
        if (conventionTaskName.startsWith("run")) {
            return conventionTaskName;
        }
        return prefix + StringCapitalizationUtils.capitalize((String)conventionTaskName);
    }
}

