/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.util.HashSet;
import java.util.Set;
import net.neoforged.gradle.dsl.common.extensions.ProjectHolder;
import net.neoforged.gradle.dsl.common.extensions.RunnableSourceSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.Nullable;

public class SourceSetUtils {
    private SourceSetUtils() {
        throw new IllegalStateException("Tried to create utility class!");
    }

    public static Project getProject(SourceSet sourceSet) {
        ProjectHolder projectHolder = (ProjectHolder)sourceSet.getExtensions().findByType(ProjectHolder.class);
        if (projectHolder != null) {
            return projectHolder.getProject();
        }
        Set tasks = sourceSet.getOutput().getBuildDependencies().getDependencies(null);
        HashSet<Project> projects = new HashSet<Project>();
        for (Task task : tasks) {
            Project project2 = task.getProject();
            projects.add(project2);
        }
        projects.removeIf(project -> !((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).contains((Object)sourceSet));
        if (projects.size() == 1) {
            return (Project)projects.iterator().next();
        }
        throw new IllegalStateException("Could not find project for source set " + sourceSet.getName());
    }

    public static String getModIdentifier(SourceSet sourceSet, @Nullable Project project) {
        RunnableSourceSet runnableSourceSet = (RunnableSourceSet)sourceSet.getExtensions().findByType(RunnableSourceSet.class);
        if (runnableSourceSet != null) {
            return (String)runnableSourceSet.getModIdentifier().get();
        }
        if (project == null) {
            return SourceSetUtils.getProject(sourceSet).getName();
        }
        return project.getName();
    }
}

