/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import javax.annotation.Nullable;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.util.HashFunction;
import org.apache.commons.io.FileUtils;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public final class FileDownloadingUtils {
    private FileDownloadingUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: FileDownloadingUtils. This is a utility class");
    }

    public static boolean downloadThrowing(boolean isOffline, DownloadInfo info, File file) {
        try {
            return FileDownloadingUtils.downloadTo(isOffline, info, file);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to download the file from: %s to: %s", info.url, file), e);
        }
    }

    public static boolean downloadTo(boolean isOffline, DownloadInfo info, File file) throws IOException {
        File localPath;
        if (info.type.equals("jar") && info.side.equals("client") && (localPath = new File(FileDownloadingUtils.getMCDir() + File.separator + "versions" + File.separator + info.version + File.separator + info.version + ".jar")).exists() && HashFunction.SHA1.hash(localPath).equalsIgnoreCase(info.hash)) {
            FileUtils.copyFile((File)localPath, (File)file);
            return true;
        }
        if (!isOffline) {
            return FileDownloadingUtils.copyURLToFileIfNewer(new URL(info.url), file.toPath());
        }
        if (!file.exists()) {
            throw new RuntimeException("Could not find the file: " + file + " and we are offline.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyURLToFileIfNewer(URL url, Path target) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        try {
            boolean bl;
            if (Files.isRegularFile(target, new LinkOption[0])) {
                FileTime lastModified = Files.getLastModifiedTime(target, new LinkOption[0]);
                urlConnection.setIfModifiedSince(lastModified.toMillis());
                if (urlConnection.getResponseCode() == 304) {
                    if (urlConnection.getLastModified() != 0L && urlConnection.getLastModified() != urlConnection.getIfModifiedSince()) {
                        urlConnection.disconnect();
                        urlConnection = (HttpURLConnection)url.openConnection();
                    } else {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
            }
            if (urlConnection.getResponseCode() != 200) {
                throw new IOException("Failed to download " + url + ", HTTP-Status: " + urlConnection.getResponseCode());
            }
            if (target.getParent() == null) {
                target = target.toAbsolutePath();
            }
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile(target.getParent(), target.getFileName().toString(), ".download", new FileAttribute[0]);
            try {
                try (InputStream stream = urlConnection.getInputStream();){
                    Files.copy(stream, tempFile, StandardCopyOption.REPLACE_EXISTING);
                }
                FileDownloadingUtils.move(target, tempFile);
                if (urlConnection.getLastModified() != 0L) {
                    Files.setLastModifiedTime(target, FileTime.fromMillis(urlConnection.getLastModified()));
                }
                bl = true;
            }
            catch (Throwable throwable) {
                Files.deleteIfExists(tempFile);
                throw throwable;
            }
            Files.deleteIfExists(tempFile);
            return bl;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    private static void move(Path target, Path tempFile) throws IOException {
        int tries = 0;
        while (true) {
            ++tries;
            try {
                try {
                    Files.move(tempFile, target, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(tempFile, target, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                if (tries >= 5) {
                    throw e;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public static File getMCDir() {
        switch (VersionJson.OS.getCurrent()) {
            case OSX: {
                return new File(System.getProperty("user.home") + "/Library/Application Support/minecraft");
            }
            case WINDOWS: {
                return new File(System.getenv("APPDATA") + "\\.minecraft");
            }
        }
        return new File(System.getProperty("user.home") + "/.minecraft");
    }

    public static class DownloadInfo
    implements Serializable {
        private String url;
        private String hash;
        private String type;
        private String version;
        private String side;

        public DownloadInfo(String url, @Nullable String hash, String type, @Nullable String version, @Nullable String side) {
            this.url = url;
            this.hash = hash;
            this.type = type;
            this.version = version;
            this.side = side;
        }

        @Input
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Input
        @Optional
        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        @Input
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Input
        @Optional
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @Input
        @Optional
        public String getSide() {
            return this.side;
        }

        public void setSide(String side) {
            this.side = side;
        }
    }
}

