/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.neoforged.gradle.common.tasks.DownloadingTask;
import org.codehaus.groovy.control.io.NullWriter;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;

@CacheableTask
public abstract class JarExec
extends DownloadingTask {
    protected boolean hasLog = true;
    protected final Provider<Directory> workDir = this.getProject().getLayout().getBuildDirectory().dir(this.getName());
    protected final Provider<RegularFile> logFile = this.workDir.map(d -> d.file("log.txt"));

    public JarExec() {
        this.getDebug().convention((Object)false);
        JavaPluginExtension extension = (JavaPluginExtension)this.getProject().getExtensions().findByType(JavaPluginExtension.class);
        if (extension != null) {
            this.getJavaLauncher().convention(this.getJavaToolchainService().launcherFor(extension.getToolchain()));
        }
    }

    @Inject
    protected JavaToolchainService getJavaToolchainService() {
        throw new UnsupportedOperationException("Decorated instance, this should never be thrown unless shenanigans");
    }

    @TaskAction
    public void apply() throws IOException {
        String[] workingDirContents;
        File jar = ((RegularFile)this.getToolJar().get()).getAsFile();
        File logFile = ((RegularFile)this.logFile.get()).getAsFile();
        JarFile jarFile = new JarFile(jar);
        String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        jarFile.close();
        Logger logger = this.getProject().getLogger();
        if (logFile.getParentFile() != null && !logFile.getParentFile().exists() && !logFile.getParentFile().mkdirs()) {
            logger.warn("Could not create parent directory '{}' for log file", (Object)logFile.getParentFile().getAbsolutePath());
        }
        boolean debug = (Boolean)this.getDebug().get();
        List<String> args = this.filterArgs((List)this.getArgs().get());
        ConfigurableFileCollection classpath = this.getProject().files(new Object[]{this.getToolJar(), this.getClasspath()});
        File workingDirectory = ((Directory)this.workDir.get()).getAsFile();
        try (final PrintWriter log = new PrintWriter((Writer)(this.hasLog ? new FileWriter(logFile) : NullWriter.DEFAULT), true);){
            this.getProject().javaexec(spec -> {
                spec.setExecutable(this.getEffectiveExecutable());
                spec.setDebug(debug);
                spec.setArgs(args);
                spec.setClasspath((FileCollection)classpath);
                spec.setWorkingDir(workingDirectory);
                spec.getMainClass().set((Object)mainClass);
                log.println("Java Launcher: " + spec.getExecutable());
                log.println("Arguments: " + args.stream().collect(Collectors.joining(", ", "'", "'")));
                log.println("Classpath:");
                classpath.forEach(f -> log.println(" - " + f.getAbsolutePath()));
                log.println("Working directory: " + workingDirectory.getAbsolutePath());
                log.println("Main class: " + mainClass);
                log.println("====================================");
                spec.setStandardOutput(new OutputStream(){

                    @Override
                    public void flush() {
                        log.flush();
                    }

                    @Override
                    public void close() {
                    }

                    @Override
                    public void write(int b) {
                        log.write(b);
                    }
                });
            }).rethrowFailure().assertNormalExitValue();
        }
        if (this.hasLog) {
            this.postProcess(logFile);
        }
        if (!((workingDirContents = workingDirectory.list()) != null && workingDirContents.length != 0 || workingDirectory.delete())) {
            logger.warn("Could not delete empty working directory '{}'", (Object)workingDirectory.getAbsolutePath());
        }
    }

    protected List<String> filterArgs(List<String> args) {
        return args;
    }

    protected void postProcess(File log) {
    }

    protected List<String> replaceArgsMulti(List<String> args, @Nullable Map<String, ?> normalReplacements, @Nullable Multimap<String, ?> multiPrefixedReplacements) {
        multiPrefixedReplacements = multiPrefixedReplacements != null ? multiPrefixedReplacements : ImmutableMultimap.of();
        return this.replaceArgs(args, normalReplacements, multiPrefixedReplacements.asMap());
    }

    protected List<String> replaceArgs(List<String> args, @Nullable Map<String, ?> normalReplacements, @Nullable Map<String, ? extends Collection<?>> multiPrefixedReplacements) {
        normalReplacements = normalReplacements != null ? normalReplacements : Collections.emptyMap();
        Map<String, Collection<Object>> map = multiPrefixedReplacements = multiPrefixedReplacements != null ? multiPrefixedReplacements : Collections.emptyMap();
        if (normalReplacements.isEmpty() && multiPrefixedReplacements.isEmpty()) {
            return args;
        }
        ArrayList<String> newArgs = new ArrayList<String>(args.size());
        for (String arg : args) {
            if (multiPrefixedReplacements.containsKey(arg)) {
                String prefix = newArgs.isEmpty() ? null : newArgs.remove(newArgs.size() - 1);
                for (Object value : multiPrefixedReplacements.get(arg)) {
                    if (prefix != null) {
                        newArgs.add(prefix);
                    }
                    newArgs.add(this.toString(value));
                }
                continue;
            }
            if (normalReplacements.containsKey(arg)) {
                newArgs.add(this.toString(normalReplacements.get(arg)));
                continue;
            }
            newArgs.add(arg);
        }
        return newArgs;
    }

    private String toString(Object obj) {
        if (obj instanceof File) {
            return ((File)obj).getAbsolutePath();
        }
        if (obj instanceof Path) {
            return ((Path)obj).toAbsolutePath().toString();
        }
        return Objects.toString(obj);
    }

    @Input
    public boolean getHasLog() {
        return this.hasLog;
    }

    public void setHasLog(boolean value) {
        this.hasLog = value;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getToolJar();

    @Input
    public abstract ListProperty<String> getArgs();

    @Input
    @Optional
    public abstract Property<Boolean> getDebug();

    @Optional
    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Nested
    @Optional
    public abstract Property<JavaLauncher> getJavaLauncher();

    public void setMinimumRuntimeJavaVersion(int version) {
        if (!this.getJavaLauncher().isPresent() || !((JavaLauncher)this.getJavaLauncher().get()).getMetadata().getLanguageVersion().canCompileOrRun(version)) {
            this.setRuntimeJavaVersion(version);
        }
    }

    public void setRuntimeJavaVersion(int version) {
        this.setRuntimeJavaToolchain((Action<? super JavaToolchainSpec>)((Action)tc -> tc.getLanguageVersion().set((Object)JavaLanguageVersion.of((int)version))));
    }

    public void setRuntimeJavaToolchain(JavaToolchainSpec toolchain) {
        this.getJavaLauncher().set(this.getJavaToolchainService().launcherFor(toolchain));
    }

    public void setRuntimeJavaToolchain(Action<? super JavaToolchainSpec> action) {
        this.getJavaLauncher().set(this.getJavaToolchainService().launcherFor(action));
    }

    private String getEffectiveExecutable() {
        if (this.getJavaLauncher().isPresent()) {
            return ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().toString();
        }
        return Jvm.current().getJavaExecutable().getAbsolutePath();
    }
}

