/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks.action;

import java.io.File;
import java.net.URL;
import javax.inject.Inject;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.gradle.util.GradleInternalUtils;
import net.neoforged.gradle.util.HashFunction;
import net.neoforged.gradle.util.UrlUtils;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class DownloadFileAction
implements WorkAction<Params> {
    private static final int MAX_ATTEMPTS = 10;
    private static final int ATTEMPT_DELAY = 100;
    private static final Logger LOGGER = Logging.getLogger(DownloadFileAction.class);

    @Inject
    public abstract BuildServiceRegistry getBuildServiceRegistry();

    public void execute() {
        try {
            String hash;
            String hash2;
            Params params = (Params)this.getParameters();
            File output = ((RegularFile)params.getOutputFile().get()).getAsFile();
            if (output.exists() && ((Boolean)params.getShouldValidateHash().get()).booleanValue() && (hash2 = HashFunction.SHA1.hash(output)).equals(params.getSha1().get())) {
                return;
            }
            GradleInternalUtils.ProgressLoggerWrapper progress = GradleInternalUtils.getProgressLogger((Logger)LOGGER, (Object)this.getBuildServiceRegistry(), (String)("Downloading file: " + (String)params.getUrl().get()));
            progress.setDestFileName(((File)params.getOutputFile().getAsFile().get()).getName());
            if (((Boolean)params.getIsOffline().get()).booleanValue()) {
                String hash3;
                if (!output.exists()) {
                    throw new IllegalStateException("Cannot download asset " + (String)params.getUrl().get() + " as Gradle is running in offline mode and the file does not exist");
                }
                int size = FileUtils.getFileSize((File)output);
                progress.setSize((long)size);
                progress.started();
                if (((Boolean)params.getShouldValidateHash().get()).booleanValue() && !(hash3 = HashFunction.SHA1.hash(output)).equals(params.getSha1().get())) {
                    throw new IllegalStateException(String.format("Cannot validate asset %s as Gradle is running in offline mode and the file does not match the expected hash. Expected: %s Actual: %s", params.getUrl().get(), params.getSha1().get(), hash3));
                }
                progress.incrementDownloadProgress((long)size);
                progress.completed();
                return;
            }
            URL url = new URL((String)params.getUrl().get());
            for (int attempt = 0; attempt < 10; ++attempt) {
                try {
                    progress.setSize(UrlUtils.getFileSize((URL)url));
                    FileUtil.copy((URL)url, (File)output, (CopyProgressListener)new Monitor(progress), (TimeoutConstraint)Timeout.NONE);
                    break;
                }
                catch (Exception e) {
                    if (attempt == 9) {
                        throw e;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
            }
            if (((Boolean)params.getShouldValidateHash().get()).booleanValue() && !(hash = HashFunction.SHA1.hash(output)).equals(params.getSha1().get())) {
                throw new IllegalStateException(String.format("Cannot validate asset %s as Gradle is running in offline mode and the file does not match the expected hash. Expected: %s Actual: %s", params.getUrl().get(), params.getSha1().get(), hash));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Params
    extends WorkParameters {
        public Property<String> getUrl();

        public Property<String> getSha1();

        public Property<Boolean> getShouldValidateHash();

        public RegularFileProperty getOutputFile();

        public Property<Boolean> getIsOffline();
    }

    private static final class Monitor
    implements CopyProgressListener {
        private final GradleInternalUtils.ProgressLoggerWrapper progress;

        private Monitor(GradleInternalUtils.ProgressLoggerWrapper progress) {
            this.progress = progress;
        }

        public void start(CopyProgressEvent evt) {
            this.progress.started();
            this.progress.incrementDownloadProgress((long)evt.getReadBytes());
        }

        public void progress(CopyProgressEvent evt) {
            this.progress.incrementDownloadProgress((long)evt.getReadBytes());
        }

        public void end(CopyProgressEvent evt) {
            this.progress.incrementDownloadProgress((long)evt.getReadBytes());
            this.progress.completed();
        }
    }

    private static final class Timeout
    implements TimeoutConstraint {
        private static final Timeout NONE = new Timeout();

        private Timeout() {
        }

        public int getConnectionTimeout() {
            return -1;
        }

        public int getReadTimeout() {
            return -1;
        }
    }
}

