/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CollectDependencyLibraries
extends DefaultRuntime {
    public CollectDependencyLibraries() {
        this.getOutputFileName().convention((Object)"libraries.txt");
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getBaseLibraryFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getDependencyFiles();

    @TaskAction
    public void execute() throws IOException {
        File output = this.ensureFileWorkspaceReady(((RegularFile)this.getOutput().get()).getAsFile());
        File definitionLibraries = ((RegularFile)this.getBaseLibraryFile().get()).getAsFile();
        FileUtils.copyFile((File)definitionLibraries, (File)output);
        for (File file : this.getDependencyFiles()) {
            FileUtils.write((File)output, (CharSequence)("\n-e=" + file.getAbsolutePath()), (boolean)true);
        }
    }
}

